% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDM.R
\name{pca.tpdm}
\alias{pca.tpdm}
\title{Principal Component Analysis for TPDM}
\usage{
pca.tpdm(Sigma, data)
}
\arguments{
\item{Sigma}{A n x n data array, containing the TPDM, can be output of \link{est.tpdm}.}

\item{data}{A t x n dimensional, numeric Data-matrix with t: Number of time steps and n: Number of grid points/stations.}
}
\value{
list containing
\itemize{
    \item pc: The Principal Components of TPDM
    \item basis: The Eigenvectors of TPDM
    \item extremal.basis: The Eigenvectors of TPDM but transformed in positive reals with \link{trans}
}
}
\description{
Calculates principal component analysis (PCA) of given TPDM
}
\references{
Jiang & Cooley (2020) <doi:10.1175/JCLI-D-19-0413.1>
}
\author{
Yuing Jiang, Dan Cooley
}
