% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqER.R
\name{seqER}
\alias{seqER}
\title{Computes sequential evidence ratios}
\usage{
seqER(ic = bic, mod1, mod2, nmin = 10, id = NULL, boundary = Inf,
  blind = FALSE, nsims = NULL)
}
\arguments{
\item{ic}{Indicates whether to use the aic or the bic.}

\item{mod1}{A model of class \code{lm} or \code{lmerMod}.}

\item{mod2}{A model of class \code{lm} or \code{lmerMod} (of the same class of mod1).}

\item{nmin}{Minimum sample size from which start to compute sequential evidence ratios.}

\item{id}{If applicable (i.e., repeated measures), name of the "id" column of your
dataframe, in character string.}

\item{boundary}{The Evidence Ratio (or its reciprocal) at which
the run is stopped as well}

\item{blind}{If true, the function only returns a "continue or stop" message}

\item{nsims}{Number of permutation samples to evaluate (is ignored if blind = TRUE)}
}
\description{
Computes sequential evidence ratios, either based on the AIC or the BIC.
Supported models currently include \code{lm}, \code{merMod}, or \code{brmsfit} models.
When data involve repeated measures (and so multiple lines per subject),
a column indicating the subject "id" should be provided to the \code{id} argument.
If nothing is passed to the \code{id} argument, \code{seqER} will suppose
that there is only one observation (i.e., one line) per subject.
}
\examples{
\dontrun{
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + disp, mtcars)
seqER(ic = bic, mod1, mod2, nmin = 10)

# Example with ten permutation samples
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + disp, mtcars)
seqER(ic = bic, mod1, mod2, nmin = 10, nsims = 10)

# Example with blinding
data(mtcars)
mod1 <- lm(mpg ~ cyl, mtcars)
mod2 <- lm(mpg ~ cyl + disp, mtcars)
seqER(ic = bic, mod1, mod2, nmin = 10, boundary = 10, blind = TRUE)

# Example with repeated measures
library(lme4)
data(sleepstudy)
mod1 <- lmer(Reaction ~ Days + (1|Subject), sleepstudy)
mod2 <- lmer(Reaction ~ Days + I(Days^2) + (1|Subject), sleepstudy)
seqER(ic = bic, mod1, mod2, nmin = 10, id = "Subject", nsims = 10)

# Example with brmsfit models
library(brms)
mod1 <- brm(Reaction ~ Days + (1|Subject), sleepstudy)
mod2 <- brm(Reaction ~ Days + I(Days^2) + (1|Subject), sleepstudy)
seqER(ic = WAIC, mod1, mod2, nmin = 10, id = "Subject", nsims = 10)
}

}
\seealso{
\code{\link{simER}}
}
\author{
Ladislas Nalborczyk <\email{ladislas.nalborczyk@gmail.com}>
}
