#' Print Methods
#'
#' @description
#' These `print` methods for different results, including:
#' \itemize{
#'  \item Hull print for \code{\link[EFAfactors]{Hull}} results.
#'  \item Comparison Data print for \code{\link[EFAfactors]{CD}} results.
#'  \item Parallel Analysis print for \code{\link[EFAfactors]{PA}} results.
#'  \item Empirical Kaiser Criterion for \code{\link[EFAfactors]{EKC}} results.
#'  \item Kaiser-Guttman Criterion for \code{\link[EFAfactors]{KGC}} results.
#'  \item K-means print for \code{\link[EFAfactors]{EFAkmeans}} results.
#'  \item Hierarchical Clustering print for \code{\link[EFAfactors]{EFAhclust}} results.
#'  \item pre-trained Neural Networks print for \code{\link[EFAfactors]{NN}} results.
#'  \item Factor Forest for \code{\link[EFAfactors]{FF}} results.
#'  \item Comparison Data Forest print for \code{\link[EFAfactors]{CDF}} results.
#'  \item Voting Method print for \code{\link[EFAfactors]{EFAvote}} results.
#'  \item Scree print for \code{\link[EFAfactors]{EFAscreet}} results.
#'  \item Minimum Average Partial Test print for \code{\link[EFAfactors]{MAP}} results.
#'  \item Scree Test Optimal Coordinate print for \code{\link[EFAfactors]{STOC}} results.
#' }
#'
#' @param x An object of class \code{Hull}, \code{CD}, \code{PA}, \code{EKC},
#'          \code{KGC}, \code{EFAkmeans}, \code{EFAhclust}, \code{NN}, \code{FF},
#'          \code{CDF}, \code{EFAvote}, \code{EFAscreet}, \code{MAP},  or \code{STOC}.
#' @param ... Additional arguments passed to the printing functions.
#' @return None. Prints are produced as side effects.
#' @seealso \code{\link[EFAfactors]{Hull}}, \code{\link[EFAfactors]{CD}}, \code{\link[EFAfactors]{PA}},
#'          \code{\link[EFAfactors]{EKC}}, \code{\link[EFAfactors]{KGC}}, \code{\link[EFAfactors]{EFAkmeans}},
#'          \code{\link[EFAfactors]{EFAhclust}}, \code{\link[EFAfactors]{NN}}, \code{\link[EFAfactors]{FF}},
#'          \code{\link[EFAfactors]{CDF}}, \code{\link[EFAfactors]{EFAvote}}, \code{\link[EFAfactors]{EFAscreet}},
#'          \code{\link[EFAfactors]{MAP}}, \code{\link[EFAfactors]{STOC}}
#' @name print
NULL


#' @describeIn print Print method for Hull objects
#' @export
print.Hull <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by Hull is", obj$nfact, ".\n")
}


#' @describeIn print Print method for CD objects
#' @export
print.CD <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by CD is", obj$nfact, ".\n")
}

#' @describeIn print Print method for PA objects
#' @export
print.PA <- function(x, ...) {
  obj <- x
  type <- obj$type
  if(type == "quant"){
    type = paste0(type, "=", obj$quant)
  }
  cat("The number of factors suggested by PA ", paste0("(", type, ")"), " is", obj$nfact, ".\n")
}

#' @describeIn print Print method for EKC objects
#' @export
print.EKC <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by EKC is", obj$nfact, ".\n")
}

#' @describeIn print Print method for KGC objects
#' @export
print.KGC <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by KGC is", obj$nfact, ".\n")
}


#' @export
print.EFAkmeans <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by EFAkmeans-SOD is", obj$nfact.SOD, ".\n")
}

#' @describeIn print Print method for EFAhclust objects
#' @export
print.EFAhclust <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by EFAhclust-SOD is", obj$nfact.SOD, ".\n")
}

#' @describeIn print Print method for NN objects
#' @export
print.NN <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by ", obj$model, " is", obj$nfact, ".\n")
}

#' @describeIn print Print method for FF objects
#' @export
print.FF <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by FF is", obj$nfact, ".\n")
}

#' @describeIn print Print method for CDF objects
#' @export
print.CDF <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by CDF is", obj$nfact, ".\n")
}

#' @describeIn print Print method for EFAvote objects
#' @export
print.EFAvote <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by EFAvote is", obj$nfact, ".\n")
}

#' @describeIn print Print method for EFAdata objects
#' @export
print.EFAdata <- function(x, ...) {
  obj <- x
  print(obj$items)
}

#' @describeIn print Print method for EFAscreet objects
#' @export
print.EFAscreet <- function(x, ...) {
  plot(x)
}

#' @describeIn print Print method for MAP objects
#' @export
print.MAP <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by MAP is", obj$nfact, ".\n")
}


#' @export
print.STOC <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by STOC is", obj$nfact, ".\n")
}
