% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsHasSession,OpalConnection-method}
\alias{dsHasSession,OpalConnection-method}
\title{Check remote R session exists}
\usage{
\S4method{dsHasSession}{OpalConnection}(conn)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{OpalConnection-class}}.}
}
\value{
A logical indicating if a remote R session exists accessible through this connection.
}
\description{
Check if a remote R session exists (not necessarily running and ready to accept
R commands submissions).
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "administrator", password = "password", url = "https://opal-demo.obiba.org")
dsHasSession(con)
dsDisconnect(con)
}
}
