% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAnalysis.R
\name{plus_minus}
\alias{plus_minus}
\title{plus_minus}
\usage{
plus_minus(
  model,
  alternative,
  target = model$first(),
  minus = .Machine$integer.max,
  plus = .Machine$integer.max,
  print = TRUE,
  as_character = FALSE,
  round = NULL,
  id = NULL,
  evaluate = FALSE,
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object.}

\item{alternative}{Either a \code{data.frame} representing a single alternative
or an index to \code{model$alternatives}.}

\item{target}{The attribute on which effects are observed. Default: \code{model$first()}.}

\item{minus}{The maximum number of downward steps to be made for each input attribute.
Default: \code{.Machine$integer.max}.
The actual \code{minus} value is further determined with respect to
\code{alternative} values and involved attributes' scales.}

\item{plus}{The maximum number of upward steps to be made for each input attribute.
Default: \code{.Machine$integer.max}.
The actual \code{plus} value is further determined with respect to
\code{alternative} values and involved attributes' scales.}

\item{print}{\code{logical(1)}. When \code{TRUE}, pretty print (left justify) the results.}

\item{as_character}{\code{logical(1)}. Whether to represent alternative values
numerically (\code{FALSE}) or using text (\code{TRUE}).}

\item{round}{An integer number, argument to \code{\link[=value_text]{value_text()}}.}

\item{id}{\code{character(1)}.
Determines the contents of the first or first two columns of the resulting \code{data.frame}s:
\describe{
\item{\code{"id"}}{Attribute ID.}
\item{\code{"structure"}}{Attribute \verb{$structure() + $name}.}
\item{anything else}{Equivalent to both \code{"id"} and \code{"structure"}.}
}}

\item{evaluate}{\code{logical(1)}. Whether or not to evaluate \code{alternative} beforehand.}

\item{...}{Optional parameters for \code{\link[=evaluate]{evaluate()}}.}
}
\value{
A data frame consisting of columns:
\describe{
\item{\code{id}}{IDs of input attributes (unless excluded by the \code{id} argument).}
\item{\code{structure}}{Structure and names of input attributes (unless excluded by the \code{id} argument).}
\item{'For \code{-minus} to \code{-1}}{Evaluation value of \code{target} when decreasing the corresponding attribute value by the corresponding number of steps.}
\item{\code{target$id}}{Original \code{alternative} value assigned to the corresponding attribute \code{id}.}
\item{For \code{1} to \code{plus}}{Evaluation value of \code{target} when increasing the corresponding attribute value by the corresponding number of steps.}
}
Special values \code{"["} and \code{"]"} denote that it is not possible to decrease of increase, respectively,
the corresponding attributes value further.
}
\description{
Plus-Minus Analysis:
Investigate the effects of changing single attributes values on the evaluation of \code{alternative}.
The values of discrete basic attributes ("input attributes") are changed, one attribute at a time,
by a particular number of steps downwards (\code{minus}) and upwards (\code{plus}),
while observing the changes of the \code{target} attribute values.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

alt <- Car$alternative("MyCar",
       BUY.PRICE="low", MAINT.PRICE="*", X.PERS="more", X.DOORS="4", LUGGAGE=2, SAFETY=c(1, 3))
alte <- Car$evaluate(alt)

# Default plus-minus analysis, evaluating `alt`.
plus_minus(Car, alt, evaluate = TRUE)

# Plus-minus analysis of `alte`, using character strings,
# no pretty-printing and excluding structure info.
plus_minus(Car, alte, as_character=TRUE, print=FALSE, id = "id")

# Plus-minus analysis on `target="PRICE"`, using character strings.
plus_minus(Car, alt, target="PRICE", as_character=TRUE, evaluate=TRUE)
}
\seealso{
\code{\link[=evaluate]{evaluate()}}, \code{\link[=value_text]{value_text()}}
}
