% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiCharts.R
\name{plotalt2}
\alias{plotalt2}
\title{plotalt2}
\usage{
plotalt2(
  model,
  attribute1,
  attribute2,
  alternatives = NULL,
  colors = NULL,
  pch = 20,
  size = 5,
  margins = NULL,
  lm = NULL,
  pos = 4,
  offset = 1,
  ...
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{attribute1}{First attribute. It may be an \link{DexiAttribute} object or
an argument to \code{model$attrib()}. The attribute must be discrete.}

\item{attribute2}{Second attribute. It may be an \link{DexiAttribute} object or
an argument to \code{model$attrib()}. The attribute must be discrete.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects the whole \code{model$alternatives}.}

\item{colors}{\code{character()}. Colors for displaying subsequent alternatives.}

\item{pch}{Plotting character, see \code{\link[graphics:points]{graphics::points()}}. Default: \code{20}.}

\item{size}{\code{numeric(1)}. Multiplication size factor for drawing individual points.
Base point size depends on \code{pch}.}

\item{margins}{\code{numeric(4)}. Chart margins, passed to \code{\link[graphics:par]{graphics::par()}} prior to drawing.}

\item{lm}{\code{numeric(1)}. Left chart margin. May be used to adjust the display of \code{attribute2}'s values.}

\item{pos}{A position specifier for legent text, see \code{\link[graphics:text]{graphics::text()}}. Default: \code{4}.}

\item{offset}{When \code{pos} is specified, this value controls the distance of the text label
from the specified coordinate in fractions of a character width. Default: \code{1}.}

\item{...}{Optional parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
Draws a chart.
}
\description{
Draw a scatterpolot of \code{alternatives} with \code{attribute1} and \code{attribute2} on the
\eqn{x} and \eqn{y} axis, respectively.
}
\details{
Standard scatterplot \code{\link[graphics:plot.default]{graphics::plot()}} is used.
Continuous attributes are not supported.
}
\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# Plot all Car$alternatives with respect to "PRICE" and "TECH.CHAR." attributes
plotalt2(Car, "PRICE", "TECH.CHAR.")

# Plot the first Car alternative with respect to "BUY.PRICE" and "MAINT.PRICE" attributes
plotalt2(Car, "BUY.PRICE", "MAINT.PRICE", 1)

}
