% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAlternatives.R
\name{convert_data_discrete}
\alias{convert_data_discrete}
\title{convert_data_discrete}
\usage{
convert_data_discrete(
  data,
  scale,
  interpret = c("set", "distribution", "none"),
  aggregate = min,
  omin = 0,
  omax = 1,
  map_values = TRUE,
  reverse_descending = TRUE
)
}
\arguments{
\item{data}{A vector containing DEXi values: single numbers, integer vectors or distribuions.
Typically a \code{data.frame} column of DEXi alternatives' data.}

\item{scale}{A \link{DexiDiscreteScale} object or a discrete \link{DexiAttribute} object.}

\item{interpret}{Either \code{"set"} (default), \code{"distribution"} or \code{"none"}.
Determines how are individual \code{data} elements interpreted: as sets or distributions.
Actually, each element is converted either to a set or distribution prior do applying \code{aggregate()}.
When \code{interpret = "none"}, just \code{aggregate()} is applied on the original \code{value} from \code{data},
without any value scaling or reversal.}

\item{aggregate}{A function applied on each interpreted \code{data} element.
Normally a function that maps a numeric vector (set or distribution) to a single number.
Default: \code{\link[=min]{min()}}.}

\item{omin}{Lower output bound for \code{\link[=lin_map]{lin_map()}} value scaling. Applies only when \code{interpret = "set"}.}

\item{omax}{Upper output bound for \code{\link[=lin_map]{lin_map()}} value scaling  Applies only when \code{interpret = "set"}.}

\item{map_values}{\code{logical(1)}. Whether or not to perform value scaling using \code{\link[=lin_map]{lin_map()}}.
Applies only when \code{interpret = "set"}.}

\item{reverse_descending}{\code{logical(1)}. Whether or not to reverse values of a "descending" scale.}
}
\value{
Vector of converted values.
}
\description{
#' A helper function for converting individual columns of alternatives' data.
It is assumed that \code{data}  contains data corresponding to a discrete
\link{DexiAttribute}. During conversion, \code{data} elements are converted either
to sets or distributions, and function \code{aggregate} if applied on them.
When \code{interpret = "set"}, values are also optionally converted to the interval \verb{[omin:omax]},
and reversed using \code{\link[=reverse_value]{reverse_value()}} for scales whose \verb{$order = "descending"}.
}
\examples{
scla <- DexiDiscreteScale(values = c("L", "M", "H"))
scld <- DexiDiscreteScale(values = c("L", "M", "H"), order = "descending")
convert_data_discrete(c(1, 2, 3), scla)    # 0.0 0.5 1.0
convert_data_discrete(c(1, 2, 3), scld)    # 1.0 0.5 0.0
convert_data_discrete(list(1, 2, 3), scla) # 0.0 0.5 1.0
convert_data_discrete(list(1, 2, 3), scld) # 1.0 0.5 0.0
convert_data_discrete(list(1, 2, 3), scld, omax=10) # 10  5  0
data <- list(1, c(1,2), distribution(0.2, 0, 0.8), NA)
convert_data_discrete(data, scla, omax=10) #  0  0  0 NA
convert_data_discrete(data, scld, omax=10) # 10 10 10 NA
convert_data_discrete(data, scla, aggregate=max, omax=10)  #  0  5 10 NA
convert_data_discrete(data, scla, aggregate=mean, omax=10) # 0.0 2.5 5.0  NA

}
\seealso{
\code{\link[=lin_map]{lin_map()}}, \code{\link[=reverse_value]{reverse_value()}}
}
