% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiModels.R
\docType{class}
\name{DexiModel-class}
\alias{DexiModel-class}
\alias{DexiModel}
\title{DexiModel}
\description{
\code{DexiModel} is a RC class representing a DEXi model in R.
}
\details{
Normally, \code{DexiModel} objects are created by reading from a \code{.dxi} file,
previously developed by the DEXi software. In principle, all fields of a \code{DexiModel}
should be considered read-only. DEXiR does not provide any explicit
functionality for creating and changing DEXi models in R. Of course, models can still be created
and modified in R, but without integrity and consistency guarantees.
}
\section{Fields}{

\describe{
\item{\code{name}}{character. Name of the model.}

\item{\code{description}}{character. An optional textual description of the model.}

\item{\code{linking}}{logical. Indicates whether or not the model uses linked attributes,
which are used in DEXi to represent hierarchies of attributes (i.e., directed acyclic graphs) rather than trees.}

\item{\code{root}}{\link{DexiAttribute}. The virtual root of all subtrees/hierarchies of attributes in the model.}

\item{\code{attributes}}{list. A list of all \link{DexiAttribute}s that constitute the model.}

\item{\code{att_names}}{character. A list of all attribute names, as defined in the original DEXi model. Notice that
these names may contain whitespace and other "strange" characters, and may not be unique.}

\item{\code{att_ids}}{character. A list of unique attribute IDs generated by DEXiR from \code{att_names}
using \code{\link[base]{make.unique}}. When using the DEXiR package, it is strongly advised to refer to
attributes with their IDs rather than DEXi names.}

\item{\code{basic}}{list. A list of all basic (input) \link{DexiAttribute}s in the model.}

\item{\code{aggregate}}{list. A list of all aggregate (output) \link{DexiAttribute}s in the model.}

\item{\code{links}}{list. A list of all linked \link{DexiAttribute}s in the model.}

\item{\code{basic_ids}}{character. A vector of all basic attributes' unique names.}

\item{\code{aggregate_ids}}{character.  A vector of all aggregate attributes' unique names.}

\item{\code{link_ids}}{character. A vector of all linked attributes' unique names.}

\item{\code{alternatives}}{data.frame. A data frame representing decision alternatives contained
in the \code{.dxi} file.}
}}

\section{Methods}{

\describe{
\item{\code{alternative(name = "NewAlternative", ...)}}{Create a data frame containing data of one decision alternative.
\code{name}, character(1), represents the alternative's name. The arguments \code{...}
define the alternative's values to be put in the data frame.
Please see \code{\link{set_alternative}} for the syntax of \code{...}.}

\item{\code{as_character(alt, transpose = FALSE, structure = FALSE, round = NULL)}}{The argument \code{alt} is assumed to be a data frame containing data of one or more decision alternatives
with values represented by numeric vectors. \code{as_character(alt)} transforms the values of
\code{alt} into a more human-readable form using character strings.
Additionally, \code{transpose = TRUE} transposes the data frame,
so that rows correspod to attributes and columns to alternatives.
\code{structure = TRUE} additionally displays the tree structure of attributes;
the latter works only with \code{transpose = TRUE}.
\code{round} denotes the number of decimal digits for printing numeric values.}

\item{\code{att_index(atts, use_id = TRUE)}}{Find the indices of attributes.
\code{atts} is a character vector of attribute IDs (when \code{use_id = TRUE}) or original DEXi attribute
names (when \code{use_id = FALSE}). Result: a numeric vector containing the set of indices.
Example: \code{Car$att_index(c("PRICE", "TECH.CHAR."))}}

\item{\code{att_stat()}}{Count the number of all attributes (including the virtual root),
as well as the number of basic, aggregate and linked attributes in the model.
Result: a list of the form list(all=..., basic=..., aggregate=..., link=...).}

\item{\code{attrib(atts)}}{A general function for finding attributes in the model. \code{atts} is a vector or list of
\code{DexiAttribute}s, attribute indices (integer) or attribute IDs (character).
Result: a list of found \code{DexiAttribute}s (or \code{NA}s if not found).
Example: \code{Car$attrib(list(5, "PRICE", "TECH.CHAR."))}}

\item{\code{compare_alternatives(...)}}{Calls \code{\link[DEXiR]{compare_alternatives}(.self, ...)} to carry out Comparison of Alternatives.
Please see \code{\link[DEXiR]{compare_alternatives}} for the description of \code{...} arguments.}

\item{\code{convert(...)}}{Calls \code{\link[DEXiR]{convert_alternatives}(.self, ...)} to convert decision alternatives' data.
Please see \code{\link[DEXiR]{convert_alternatives}} for the description of \code{...} arguments.}

\item{\code{evaluate(...)}}{Calls \code{\link[DEXiR]{evaluate}(.self, ...)} to evaluate decision alternatives.
Please see \code{\link[DEXiR]{evaluate}} for the description of \code{...} arguments.}

\item{\code{first()}}{Return first non-virtual model attribute, i.e., first descendant of model$root.}

\item{\code{initialize(name = "", description = "", root = NULL, linking = FALSE, ...)}}{Initialize a \code{DexiModel} object.}

\item{\code{link_attributes()}}{Carries out the linking of attributes.
DEXi attributes that have the same names and value scales,
and satisfy some other constraints to prevent making cycles in the model,
are linked together so that they logically represent a single attribute.
In this way, a tree of attributes is conceptually turned in a hierarchy (directed acyclic graph).
If \code{linking = TRUE}, \code{link_attributes} is called by \code{setup()} after reading the model.}

\item{\code{plus_minus(...)}}{Calls \code{\link[DEXiR]{plus_minus}(.self, ...)} to carry out Plus-Minus Analysis.
Please see \code{\link[DEXiR]{plus_minus}} for the description of \code{...} arguments.}

\item{\code{scale(atts)}}{Find attribute scales. \code{atts} is a vector of \code{DexiAttribute}s.
Result: a vector of the corresponding \code{\link{DexiScale}}s (or \code{NA}s).}

\item{\code{selective_explanation(...)}}{Calls \code{\link[DEXiR]{selective_explanation}(.self, ...)} to carry out Selective Explanation.
Please see \code{\link[DEXiR]{selective_explanation}} for the description of \code{...} arguments.}

\item{\code{setup()}}{Called by \code{initialize()} as the last step that establishes consistent internal data structures by
making unique attribute IDs, linking attributes (if required), making lists of attributes and their IDs,
and creating a data frame of alternatives.}

\item{\code{verify()}}{Check the correctnes of a \code{DexiModel} object and its fields. Result: \code{error()} or \code{TRUE}.}
}}

\examples{
# Get ".dxi" file name
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")

# Read DEXi model
Car <- read_dexi(CarDxi)

# Print fields of Car
Car
Car$verify()
Car$name
Car$description
Car$linking
att_names(Car$attributes)
Car$att_names
Car$att_ids
Car$basic_ids
Car$aggregate_ids
Car$att_stat()
Car$scale(Car$aggregate)

# Find some attributes in the model
Car$first()
Car$attributes[[3]]
Car$attrib("PRICE")
Car$att_index("PRICE")

# Display alternatives loaded from "Car.dxi"
Car$alternatives
Car$as_character(Car$alternatives)
Car$as_character(Car$alternatives, transpose = TRUE)
Car$as_character(Car$alternatives, transpose = TRUE, structure = TRUE)

# Define and evaluate a decision alternative (some car)
alt <- Car$alternative("MyCar",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS=3, X.DOORS=3, LUGGAGE="medium", SAFETY=2)
Car$evaluate(alt)
Car$as_character(Car$evaluate(alt))

# Employ the set-based evaluation (notice how the value of SAFETY propagates upwards to TECH.CHAR.)
alt <- Car$alternative("MyCar",
         BUY.PRICE="low", MAINT.PRICE=2, X.PERS=3, X.DOORS=3, LUGGAGE="medium", SAFETY=c(2,3))
Car$evaluate(alt)
Car$as_character(Car$evaluate(alt))

# Analysis of alternatives
Car$selective_explanation(1)
Car$selective_explanation(alt)
Car$plus_minus(alt)
Car$compare_alternatives(alt)
Car$compare_alternatives(1, 2)
Car$compare_alternatives(1, alt)

}
\seealso{
\code{\link[DEXiR]{evaluate}}, \code{\link[DEXiR]{set_alternative}}, \code{\link[=read_dexi]{read_dexi()}}
}
