% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiAttributes.R
\docType{class}
\name{DexiAttribute-class}
\alias{DexiAttribute-class}
\alias{DexiAttribute}
\title{DexiAttribute}
\description{
\code{DexiAttribute} is a RC class representing a DEXi attribute in R.
}
\details{
In a DEXi model, attributes are variables that represent observed properties of decision alternatives.
Attributes are structured in a tree, so each attribute may, but need not, have one or more direct
descendants (lower-level attributes) in the tree. Attributes without descendants are called \emph{basic}
and serve as model inputs. Attributes with one or more descendants are called \emph{aggregate} and
represent model outputs. In order to represent attribute hierarchies rather than plain trees, some attributes
may be \emph{linked}: two attributes of which one links to another one collectively represent,
in a conceptual sense, a single attribute in the hierarchy.

When completely defined, each attribute is associated with a value scale represented by a
\link{DexiScale} object.
An object \link{DexiFunction} is also defined for each aggregate attribute, aimed at
defining the aggregation of the attribute's inputs to values of that attribute.
}
\section{Fields}{

\describe{
\item{\code{name}}{character. Name of the attribute as defined in the original DEXi model. Notice that such names
may not be unique and may contain characters that cannot be used for variable names in R.}

\item{\code{id}}{character. A unique identification of the attribute in the model. Derived from \code{name}
so that it can be used as a variable name in R.}

\item{\code{description}}{character. An optional textual description of the attribute.}

\item{\code{inputs}}{list of \link{DexiAttribute}s. A list of immediate descendants of this attribute in
the tree/hierarchy. \code{NULL} for basic attributes.}

\item{\code{link}}{\link{DexiAttribute}. \code{NULL} or a link to another \link{DexiAttribute}}

\item{\code{scale}}{\link{DexiScale}. Value scale associated with this attribute, or \code{NULL}.}

\item{\code{funct}}{\link{DexiFunction}. Aggregation function associated with this attribute, or \code{NULL}.}

\item{\code{parent}}{\link{DexiAttribute} or \link{DexiModel} (only for \code{DexiModel$root}). Parent
attribute of this attribute in the tree/hierarchy. The \code{DexiModel$root}'s parent
is the \link{DexiModel}, which contains all those attributes.}

\item{\code{.alternatives}}{list. An internal field providing temporary storage for names or values of alternatives
while reading them from a \code{.dxi} file.}
}}

\section{Methods}{

\describe{
\item{\code{affects(ant)}}{\code{ant} (as "antecedent") is some \code{\link{DexiAttribute}}.
The function returns \code{TRUE} if \code{ant} lies on the path leading from this attribute
towards the root, and is therefore affected by this attribute.}

\item{\code{count()}}{Return the number of \code{input}s of this attribute.}

\item{\code{dim()}}{Dimensions of the value space determined by this attribute's \code{inputs}.
Result: a numeric vector of length equal to \code{ninp()}, containing \code{DexiScale$count()} of
all descendant attributes, or \code{NA} for attributes without associated scales.
For basic attributes, \code{dim()} returns \code{NULL}.}

\item{\code{initialize(
  name = "",
  description = "",
  inputs = list(),
  id = "",
  link = NULL,
  scale = NULL,
  funct = NULL,
  parent = NULL,
  ...
)}}{Initialize a \code{DexiAttribute} object.}

\item{\code{inp_index(inp)}}{Return the index of attribute \code{inp} in \code{inputs} of this attribute.}

\item{\code{is_aggregate()}}{Logical: \code{TRUE} for aggregate attributes (attributes whose \code{ninp() > 0}).}

\item{\code{is_basic(include_linked = TRUE)}}{Logical: \code{TRUE} for basic attributes (attributes whose \code{ninp() == 0}.
\code{include_linked} determines whether linked attributes are counted as basic
(\code{TRUE}) or not (\code{FALSE}).}

\item{\code{is_continuous()}}{Logical: Indicates whether or not this is a continuous attribute.}

\item{\code{is_discrete()}}{Logical: Indicates whether or not this is a discrete attribute.}

\item{\code{is_link()}}{Logical: Indicates whether or not this is a linked attribute.}

\item{\code{level()}}{Return the level of this attribute in the hierarchy.
The level of \code{DexiModel$root} is 0.}

\item{\code{model()}}{Return the \code{DexiModel} that contains this attribute.}

\item{\code{ninp()}}{Return the number of \code{input}s of this attribute.}

\item{\code{structure()}}{Make an indentation string for this attribute, used for printing it in \code{show()}.}

\item{\code{tree_indent(none = " ", thru = "|", link = "*", last = "+", line = "-")}}{Construct a string for representing the indentation of this attribute in the model structure.
The arguments \code{none}, \code{thru}, \code{link}, \code{last} and \code{line} are
character strings to be used in the construction.}

\item{\code{verify()}}{Check the correctnes of a \code{DexiAttribute} object and its fields. Result: \code{error()} or \code{TRUE}.}
}}

\examples{
# Load "Car.dxi"
CarDxi <- system.file("extdata", "Car.dxi", package = "DEXiR")
Car <- read_dexi(CarDxi)

# For example, consider attribute PRICE
att <- Car$attrib("PRICE")

# Print fields and basic properties of att
att$verify()
att$name
att$id
att$description
att_names(att$inputs)
att$link
att$scale
att$funct
att_names(att$parent)
att$is_aggregate()
att$is_basic()
att$is_link()
att$level()
att$count()
att$ninp()
att$dim()
att$model()
att$structure()

# Check if att affects attribute CAR
att$affects(Car$attrib("CAR"))

# Find the index of other attributes in att's inputs
att$inp_index(Car$attrib("MAINT.PRICE"))
att$inp_index(Car$attrib("CAR"))
}
