% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation_mechanism.R
\name{generate_data_prtrb}
\alias{generate_data_prtrb}
\title{Generation mechanism for data perturbation consensus clustering}
\usage{
generate_data_prtrb(
  X,
  cluster.method = "pam",
  k = 3,
  resample.ratio = 0.7,
  rep = 10,
  distance.method = "euclidian",
  adj.conv = TRUE,
  func
)
}
\arguments{
\item{X}{input data Nsample x Nfeatures}

\item{cluster.method}{base clustering method: \code{c("hclust", "spectral", "pam", "custom")}}

\item{k}{number of clusters}

\item{resample.ratio}{the data ratio to use at each itteration.}

\item{rep}{maximum number of itterations at each \code{max.cluster}}

\item{distance.method}{method for distance calculation:
\code{"euclidian"}, \code{"cosine"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"}, \code{"minkowski"}.}

\item{adj.conv}{binary value to apply soft thresholding (default=\code{TRUE})}

\item{func}{user-definrd function required if \code{cluster.method = "custom"}.
The function needs two inputs of X and k}
}
\value{
matrix of clusterings Nsample x Nrepeat
}
\description{
Generation mechanism for data perturbation consensus clustering
}
\details{
Performs clustering on the purturbed samples set
Monti et al. (2003) consensus clustering algorithm
}
\examples{
X = gaussian_clusters()$X
Clusters = generate_data_prtrb(X)

}
