% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimData.OneArm.R
\name{SimData.OneArm}
\alias{SimData.OneArm}
\title{Simulating survival dataset for a one-arm design}
\usage{
SimData.OneArm(
  N = NULL,
  d = NULL,
  l = NULL,
  gamma = NULL,
  s = NULL,
  m = NULL,
  alpha = NULL,
  nu = NULL,
  design1,
  seed,
  nsim
)
}
\arguments{
\item{N}{Number of subjects plan to enrolled}

\item{d}{expected number of events observed at time \code{l}}

\item{l}{observation time}

\item{gamma}{parameter of the exponential distribution of censoring time}

\item{s}{enrollment period}

\item{m}{maximum follow-up for a single subject}

\item{alpha}{shape parameter of weibull survival distribution}

\item{nu}{scale parameter of weibull survival distribution}

\item{design1}{a list containing all the above parameters for one-arm design}

\item{seed}{random seed number}

\item{nsim}{number of simulations}
}
\value{
This function will return the simulated datasets and the according design settings
}
\description{
Simulating survival dataset for a one-arm design
}
\examples{
design1 <- TrialPred.OneArm(N=100,d=NULL,l=3,gamma=0.1
                                     ,s=12,m=6,alpha=1,nu=20)
# Simulate 100 datasets under design1
SimData.OneArm(design1=design1,seed=1234,nsim=100)

}
