% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MO.R
\name{MO}
\alias{MO}
\title{Minimal overlap rule}
\usage{
MO(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the MO rule. If \code{name = TRUE}, the name of the function (MO) as a character string.
}
\description{
This function returns the awards vector assigned by the minimal overlap rule rule (MO) to a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

The truncated claim of a claimant \eqn{i\in N} is the minimum of the claim and the endowment, that is,
\eqn{t_i(E,d)=t_i=\min\{d_i,E\},\ i=1,\dots,n.}

Suppose that each agent claims specific parts of \eqn{E} equal to her/his claim. After arranging which
parts agents claim so as to “minimize conflict”, equal division prevails among all agents claiming
a specific part and the minimal overlap rule (MO) assigns the sum of the compensations she/he gets
from the various parts that he claimed.

Let \eqn{d_0=0}. For each problem \eqn{(E,d)} and each claimant \eqn{i\in N},

1) If \eqn{E\le d_n} then
\deqn{\text{MO}_i(E,d)=\frac{t_1}{n}+\frac{t_2-t_1}{n-1}+\dots+\frac{t_i-t_{i-1}}{n-i+1}.}

2) If \eqn{E>d_n}, let \eqn{s'\in (d_{k'},d_{k'+1}]}, with \eqn{k' \in \{0,1,\dots,n-2\}}, be the unique solution to the equation \eqn{\underset{j \in N}{\sum} \max\{d_j-s,0\} =E-s}. Then,
 \deqn{\text{MO}_i(E,d)=    \begin{cases}
 \frac{d_1}{n}+\frac{d_2-d_1}{n-1}+\dots+\frac{d_i-d_{i-1}}{n-i+1}&  \text{if } i\in \{1,\dots , k'\}
 \\[4pt]
 \text{MO}_i(s',d)+d_i-s' &  \text{if } i\in \{k'+1,\dots, n\}
   \end{cases}.}
}
\examples{
E=10
d=c(2,4,7,8)
MO(E,d)
}
\references{
Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2023). Refining the Lorenz‐ranking of rules for claims problems on restricted domains. International Journal of Economic Theory 19(3), 526-558.

O'Neill, B. (1982). A problem of rights arbitration from the Talmud. Mathemathical Social Sciences. 2, 345-371.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{CD}.
}
