% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{snapshot_workflow}
\alias{snapshot_workflow}
\title{Create Complete Workflow Snapshot}
\usage{
snapshot_workflow(
  snapshot_name = NULL,
  analysis_name = "analysis",
  source_script = NULL,
  description = NULL,
  generate_docker = TRUE,
  generate_script = TRUE,
  generate_report = TRUE
)
}
\arguments{
\item{snapshot_name}{Character. Name for this snapshot. Default is timestamp.}

\item{analysis_name}{Character. Name of the analysis}

\item{source_script}{Character. Path to main analysis script}

\item{description}{Character. Description of this workflow}

\item{generate_docker}{Logical. Generate Docker configuration. Default TRUE.}

\item{generate_script}{Logical. Generate reproducible script. Default TRUE.}

\item{generate_report}{Logical. Generate reproducibility report. Default TRUE.}
}
\value{
List containing paths to generated files
}
\description{
Create a comprehensive snapshot of the entire workflow including session info,
packages, data, parameters, and generate all reproducibility artifacts.
}
\examples{
\dontrun{
# Create complete workflow snapshot
snapshot_workflow(
  snapshot_name = "analysis_v1",
  analysis_name = "main_analysis",
  source_script = "analysis.R",
  description = "Initial analysis run"
)
}
}
