% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_annotation.R
\name{marker.select}
\alias{marker.select}
\title{Select Marker Genes from a signature gene list Based on Expression Proportion and Overlap Criteria}
\usage{
marker.select(
  ref_sig_list,
  expr.prop.cutoff = 0.1,
  ntop.max = 200,
  overlap.max = 1,
  rm_mito_ribo = FALSE,
  species = "ms"
)
}
\arguments{
\item{ref_sig_list}{A list where each element corresponds to a cluster or cell type. Each element should be a data frame containing at least two columns: \code{gene} (the gene names) and \code{expr.prop} (the proportion of cells expressing each gene). Generally, it is the output of function \code{find.sig.genes}.}

\item{expr.prop.cutoff}{A numeric value specifying the minimum proportion of cells that must express a gene for it to be considered. Default is 0.1.}

\item{ntop.max}{An integer specifying the maximum number of top marker genes to be selected. Default is 200.}

\item{overlap.max}{An integer specifying the maximum allowable overlap of marker genes across clusters. If a gene appears in more than \code{overlap.max} clusters, it will be excluded. Default is 1.}

\item{rm_mito_ribo}{Logical, indicating whether to remove mitochondrial and ribosomal genes from the marker gene list. Default is \code{FALSE}.}

\item{species}{A character string specifying the species for mitochondrial and ribosomal gene detection. Options are "ms" for mouse or "hs" for human. Default is "ms".}
}
\value{
A list where each element corresponds to a cluster and contains the selected marker genes. If no markers are found, a message is printed and \code{NULL} is returned.
}
\description{
This function selects marker genes for each cluster or cell type based on expression proportion, with options to remove mitochondrial and ribosomal genes, limit the maximum number of top marker genes, and control the overlap between markers across clusters.
}
\examples{
data(toydata)

seu <- toydata$seu

seu <- ProFAST::pdistance(seu, reduction = "caesar")
sglist <- find.sig.genes(seu = seu)

markers <- marker.select(sglist, expr.prop.cutoff = 0.1, overlap.max = 1)
print(markers)

}
\seealso{
\code{\link{find.sig.genes}} for signature gene list.
}
