% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{bdapply}
\alias{bdapply}
\title{Apply a function to each SNP in a
binary dosage file}
\usage{
bdapply(bdinfo, func, ...)
}
\arguments{
\item{bdinfo}{List with information about the
binary dosage file returned from getbdinfo}

\item{func}{A user supplied function to apply
to the data for each snp. The function must be
provide with the following parameters, dosage,
p0, p1, and p2, where dosage is the dosage values
for each subject and p0, p1, and p2 are the
probabilities that a subject has zero, one,
and two copies of the alternate allele,
respectively.}

\item{...}{Additional parameters needed by the
user supplied function}
}
\value{
A list with length equal to the number
of SNPs in the binary dosage file. Each element
of the list is the value returned by the user
supplied function
}
\description{
A routine that reads in the SNP data serially
from a binary dosage file and applies a user
specified function to the data.
}
\examples{
# Get information about a binary dosage file

vcf1abdfile <- system.file("extdata", "vcf1a.bdose", package = "BinaryDosage")
bdinfo <- getbdinfo(bdfiles = vcf1abdfile)

# Apply the getaaf, get alternate allele frequency, function
# to all the SNPs in the binary dosage file

aaf <- bdapply(bdinfo = bdinfo,
               func = BinaryDosage:::getaaf)
}
\seealso{
Other Iterating functions: 
\code{\link{genapply}()},
\code{\link{vcfapply}()}
}
\concept{Iterating functions}
