% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidimensional.R
\name{anova.lm2}
\alias{anova.lm2}
\title{Anova for lm2 objects}
\usage{
\method{anova}{lm2}(object, ...)
}
\arguments{
\item{object}{an object of class "lm2"}

\item{...}{further objects of class "lm2"}
}
\value{
an anova data frame
}
\description{
Anova for lm2 objects, returns a table with pairwise comparisons
between models or, if only one model was supplied, with the null model.
}
\examples{
lm2euc <- lm2(depV1+depV2~indepV1+indepV2, NakayaData, transformation = 'Euclidean')
lm2aff <- lm2(depV1+depV2~indepV1+indepV2, NakayaData, transformation = 'Affine')
anova(lm2euc, lm2aff)
}
\seealso{
\code{\link{lm2}}
}
