% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_copula.R
\name{bi.dist.gaussian_copula}
\alias{bi.dist.gaussian_copula}
\title{Gaussian Copula Distribution}
\usage{
bi.dist.gaussian_copula(
  marginal_dist,
  correlation_matrix = py_none(),
  correlation_cholesky = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{marginal_dist}{Distribution: Distribution whose last batch axis is to be coupled.}

\item{correlation_matrix}{array_like, optional: Correlation matrix of the coupling multivariate normal distribution. Defaults to `reticulate::py_none()`.}

\item{correlation_cholesky}{array_like, optional: Correlation Cholesky factor of the coupling multivariate normal distribution. Defaults to `reticulate::py_none()`.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{jnp.ndarray, bool, optional: Optional boolean array to mask observations. Defaults to `reticulate::py_none()`.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{numeric vector: A multi-purpose argument for shaping. When `sample=FALSE` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=TRUE` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{int: The number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{bool, optional: If `TRUE`, returns the raw BI distribution object instead of creating a sample site. This is essential for building complex distributions like `MixtureSameFamily`. Defaults to `FALSE`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Gaussian Copula distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Gaussian Copula distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
A distribution that links the `batch_shape[:-1]` of a marginal distribution with a multivariate Gaussian copula, odelling the correlation between the axes.
A copula is a multivariate distribution over the uniform distribution on [0, 1].
The Gaussian copula links the marginal distributions through a multivariate normal distribution.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.gaussian_copula(
  marginal_dist = bi.dist.gamma(concentration = 1 ,  create_obj = TRUE) ,
  correlation_matrix =  matrix(c(1.0, 0.7, 0.7, 1.0),, nrow = 2, byrow = TRUE),
  sample = TRUE)
}
}
