% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_spline.R
\name{summary.bsimSpline}
\alias{summary.bsimSpline}
\title{Summarize bsimSpline Results}
\usage{
\method{summary}{bsimSpline}(object, verbose = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{bsimSpline}.}

\item{verbose}{Logical. If \code{TRUE}, the summary values for all chain is printed.}

\item{...}{Further arguments passed to \code{\link{summary}}.}
}
\value{
The function summarizes posterior MCMC samples by reporting key statistics, including:
\itemize{
\item Posterior mean and median
\item Empirical standard deviation
\item 95\% credible interval (lower and upper quantiles)
\item Potential scale reduction factor (\code{gelman}) for multiple chains
\item Effective sample size (\code{ESS})
}

By default, only the index vector and error variance are included in the summary.
If a uniform sphere prior is used, the indicator vector (\code{nu}) is also summarized.
Note that the potential scale reduction factor for \code{nu} can be reported as
\code{NaN} or \code{Inf}, since the indicator rarely changes during the MCMC run.
}
\description{
Provides a \code{summary} method for objects of class \code{bsimSpline}, corresponding to a
single-index model with a Gaussian process link function.
}
\details{
A \code{data.frame} of summary statistics for MCMC samples. Each row corresponds to
a model parameter, and columns report the statistics.
}
\seealso{
\code{\link[coda]{gelman.diag}}, \code{\link[coda]{effectiveSize}}
}
