% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ermod.R
\name{sim_er_new_exp_marg}
\alias{sim_er_new_exp_marg}
\alias{sim_er_curve_marg}
\title{Calculate marginal expected response for specified exposure values}
\usage{
sim_er_new_exp_marg(
  ermod,
  exposure_to_sim_vec = NULL,
  data_cov = extract_data(ermod),
  n_subj_sim = 100,
  n_draws_sim = 500,
  seed_sample_draws = NULL,
  output_type = c("draws", "median_qi"),
  qi_width = 0.95
)

sim_er_curve_marg(
  ermod,
  exposure_range = NULL,
  num_exposures = 51,
  data_cov = extract_data(ermod),
  n_subj_sim = 100,
  n_draws_sim = 500,
  seed_sample_draws = NULL,
  output_type = c("draws", "median_qi"),
  qi_width = 0.95
)
}
\arguments{
\item{ermod}{An object of class \code{ermod}}

\item{exposure_to_sim_vec}{Vector of exposure values to simulate.}

\item{data_cov}{Data frame containing covariates to use for simulation.
Different from \code{\link[=sim_er_new_exp]{sim_er_new_exp()}}, \code{data_cov} can be large as long as
\code{n_subj_sim} is set to a reasonable number. Default is set to
\code{extract_data(ermod)} which is the full data used to fit the model.}

\item{n_subj_sim}{Maximum number of subjects to simulate. Default of 100
should be sufficient in many cases, as it's only used for marginal
response calculation.
Set to NULL to use all subjects in \code{data_cov} without resampling;
in this case, be mindful of the computation time.}

\item{n_draws_sim}{Number of draws for simulation. Default is set to 500
to reduce computation time for marginal response calculation.}

\item{seed_sample_draws}{Seed for sampling draws. Default is NULL.}

\item{output_type}{Type of output. "draws" returns the raw draws from the
simulation, and "median_qi" returns the median and quantile interval.}

\item{qi_width}{Width of the quantile interval. Default is 0.95. Only
used when \code{output_type = "median_qi"}.}

\item{exposure_range}{Range of exposure values to simulate. If NULL
(default), it is set to the range of the exposure variable in the original
data for model development.}

\item{num_exposures}{Number of exposure values to simulate.}
}
\value{
\code{ersim_marg} object, which is a tibble with the simulated marginal
expected response with some additional information in object attributes.
In case of \code{output_type = "median_qi"}, it returns \code{ersim_marg_med_qi}
object.
}
\description{
Responses at specified exposure values are calculated for \code{n_subj_sim}
subjects with different covariates (sampled from \code{newdata}),
and the predicted responses are "marginalized" (averaged),
resulting in marginal expected response on the
population of interest.
}
\details{
\code{\link[=sim_er_new_exp_marg]{sim_er_new_exp_marg()}} returns a tibble with the marginal expected
response for each exposure value in \code{exposure_to_sim_vec}.

\code{\link[=sim_er_curve_marg]{sim_er_curve_marg()}} is a wrapper function for \code{\link[=sim_er_new_exp_marg]{sim_er_new_exp_marg()}}
that use a range of exposure values to simulate the marginal expected
responses. Particularly useful for plotting the exposure-response curve.
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

ersim_new_exp_marg_med_qi <- sim_er_new_exp_marg(
  ermod_bin,
  exposure_to_sim_vec = seq(2, 6, by = 0.2),
  data_cov = dplyr::tibble(BHBA1C_5 = 4:10),
  n_subj_sim = NULL,
  n_draws_sim = 500, # This is set to make the example run faster
  output_type = "median_qi"
)

ersim_new_exp_marg_med_qi
}

}
\seealso{
\code{\link[=calc_ersim_med_qi]{calc_ersim_med_qi()}} for calculating median and quantile interval
from \code{ersim_marg} object (generated with \code{output_type = "draws"}).
}
