% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gibbs.R
\name{run_gibbs}
\alias{run_gibbs}
\title{Runs the Gibbs sampler algorithm using using initial values for the parameters}
\usage{
run_gibbs(
  M,
  N,
  w,
  d,
  as = 2,
  bs = 100,
  al = 2,
  bl = 1000,
  a = 2,
  b = 1000,
  alpha0 = 1/100,
  lambda = 2,
  maxIter = 10000,
  par.values,
  data,
  cluster,
  sigma2
)
}
\arguments{
\item{M}{A scalar representing the number of points available for each observation}

\item{N}{A scalar representing the number of observations}

\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{d}{A scalar representing the number of clusters.}

\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{al}{The hyperparameter value for the shape parameter in the gamma prior for lambda}

\item{bl}{The hyperparameter value for the scale parameter in the gamma prior for lambda}

\item{a}{The hyperparameter value for the shape parameter in the gamma prior for alpha0}

\item{b}{The hyperparameter value for the scale parameter in the gamma prior for alpha0}

\item{alpha0}{A scalar defining the parameter for the Dirichlet process prior
that controls the number of clusters (or its initial values)}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{maxIter}{A scalar for the number of iteration to run in the Gibbs sampler}

\item{par.values}{A list with lists with parameters for each cluster.
The first argument in each list is the number of change points,
then the positions for the change points,
where T_1 = 1, T_last = M + 1, and for each interval between change points
you need to specify a value for the constant level. If running the
Gibbs sampler for a dataset with unknown number of change points,
we suggest setting the number of change points for each cluster to be zero.
Check example in README file.}

\item{data}{a matrix of size M x N with data sequences in the columns}

\item{cluster}{a vector with cluster assignments for each data sequence}

\item{sigma2}{a vector with variance components for each data sequence}
}
\value{
A list with estimates for each iteration of the Gibbs sampler for each parameter
}
\description{
Runs the Gibbs sampler algorithm using using initial values for the parameters
}
\examples{
\donttest{
d = 2 # two clusters
N = 5 # 5 data sequences
M = 50 # 50 observations for each data sequence
maxIter = 10 # number of Gibbs sampler iterations

data(data)
# initial values for each paramter and each cluster
par.values <- list(K = c(0, 0), Tl = list(50, 50), alpha = list(5, 10))
#cluster assignment for each data sequence
cluster <- kmeans(t(data), 2)$cluster
# variance for each data sequence
sigma2 <- apply(data, 2, var)
res <- run_gibbs(M, N, w = 10, d, as = 2, bs = 100, al = 2, bl = 1000, a = 2,
 b = 1000, alpha0 = 1/100, lambda = 2, maxIter = 10, par.values, data,
 cluster, sigma2)
}
}
