% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{plot.BLRPM}
\alias{plot.BLRPM}
\title{Plotting of an object of \code{class} BLRPM}
\usage{
\method{plot}{BLRPM}(x, ..., OSC = FALSE, start.time = NULL,
  end.time = NULL, legend = TRUE, c.axis = 1.5, c.lab = 1.5,
  c.legend = 1.5)
}
\arguments{
\item{x}{\code{class} BLRPM object which is returned by function \code{BLRPM.sim}}

\item{...}{Arguments to be passed to methods, such as \link{graphical parameters} (see \code{\link{par}}).}

\item{OSC}{\code{logical} determing type of plot. OSC=True only storms and cells are plotted. OSC=FALSE storms, cells, 
stepfunction and precipitation time series plotted.}

\item{start.time}{\code{numerical} value setting the starting time of a time window to be plotted. Default is NULL, therefore start time is 0}

\item{end.time}{\code{numerical} value setting the end time of a time window to be plotted. Default is NULL, meaning the plot will 
end with the last active cell}

\item{legend}{\code{logical} setting the option for legend to be plotted or not}

\item{c.axis}{\code{numerical} value for axis label size, default is 1.5}

\item{c.lab}{\code{numerical} value for plot label size, default is 1.5}

\item{c.legend}{\code{numerical} value for legend font size, default is 1.5}
}
\description{
\code{plot.BLRPM} plots an object of \code{class} BLRPM returned by the function \code{BLRPM.sim} with an option to plot
either only the storms and cells or to additionally plot the stepfunction and the precipitation time series
in a multiframe plot.
}
\examples{
lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4
t.sim <- 240
t.acc <- t.sim
interval <- 1
offset <- 0
simulation <- BLRPM.sim(lambda,gamma,beta,eta,mux,t.sim,t.acc=t.sim,interval,offset)
plot(simulation,OSC=FALSE)
\donttest{
plot(simulation,OSC=TRUE,start.time=1,end.time=24)
}
}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}
\seealso{
\code{\link{plot}}
}

