% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tolProb.R
\name{tolProb}
\alias{tolProb}
\title{tolProb}
\usage{
tolProb(n, k, alpha = 0.05)
}
\arguments{
\item{n}{Sample size}

\item{k}{Number of discordance pairs, discordance pairs are defined as samples with difference greater than average interval}

\item{alpha}{Discordance rate, default 0.05.}
}
\value{
tolerance probability
}
\description{
Function tolProb calculates tolerance probability based on
sample size (n), number of discordance pairs (k) and discordance rate (alpha).
}
\details{
Function tolProb calculates tolearance probability based on sample size(n), number of discordance pairs (k) and discordance rate (alpha).
Its value is calculated as the largest value such that the following inequality is true:
 \deqn{1-\sum _{i=0}^{k} {n\choose i} * {(1-\alpha)}^{n-i} * {\alpha}^i \ge \beta}
}
\examples{
tolProb(n=52, k=5, alpha=0.05)
tolProb(n=52, k=0, alpha=0.05)
}
\references{
Jason J. Z. Liao, Quantifying an Agreement Study, Int. J. Biostat. 2015; 11(1): 125-133
}
\author{
Jialin Xu, Jason Liao
}
