% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_BoxCoxAttributes.r
\name{ATA.BoxCoxAttr}
\alias{ATA.BoxCoxAttr}
\title{The ATA.BoxCoxAttr function works with many different types of inputs.}
\usage{
ATA.BoxCoxAttr(
  bcMethod = "guerrero",
  bcLower = 0,
  bcUpper = 5,
  bcBiasAdj = FALSE
)
}
\arguments{
\item{bcMethod}{Choose method to be used in calculating lambda. "guerrero" (Guerrero, V.M. (1993) is default. Other method is "loglik").}

\item{bcLower}{Lower limit for possible lambda values. The lower value is limited by -5. Default value is 0.}

\item{bcUpper}{Upper limit for possible lambda values. The upper value is limited by 5. Default value is 5.}

\item{bcBiasAdj}{Use adjusted back-transformed mean for Box-Cox transformations.
If transformed data is used to produce forecasts and fitted values, a regular back transformation will result in median forecasts.
If bcBiasAdj is TRUE, an adjustment will be made to produce mean forecasts and fitted values.
If bcBiasAdj=TRUE. Can either be the forecast variance, or a list containing the interval \code{level}, the corresponding \code{upper} and \code{lower} intervals.}
}
\value{
An object of class \code{ataoptim}.
}
\description{
The ATA.BoxCoxAttr function works with many different types of inputs.
}
\references{
#'\insertRef{boxcox1964}{ATAforecasting}

#'\insertRef{guerrero1993}{ATAforecasting}
}
\seealso{
\code{\link[forecast]{BoxCox}}, \code{\link[forecast]{InvBoxCox}}, \code{\link[forecast]{BoxCox.lambda}}
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
