/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class LongestAliphaticChainDescriptor
extends AbstractMolecularDescriptor {
    public static final String CHECK_RING_SYSTEM = "checkRingSystem";
    private boolean checkRingSystem = false;
    private static final String[] NAMES = new String[]{"nAtomLAC"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#longestAliphaticChain", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("LongestAliphaticChainDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Expected parameter of type " + Boolean.class);
        }
        this.checkRingSystem = (Boolean)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkRingSystem};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(0), this.getDescriptorNames(), e);
    }

    private static boolean isAcyclicCarbon(IAtom atom) {
        return atom.getAtomicNumber() == 6 && !atom.isInRing();
    }

    private static int getMaxDepth(int[][] adjlist, int v, int prev) {
        int longest = 0;
        for (int w : adjlist[v]) {
            int length;
            if (w == prev || (length = LongestAliphaticChainDescriptor.getMaxDepth(adjlist, w, v)) <= longest) continue;
            longest = length;
        }
        return 1 + longest;
    }

    public DescriptorValue calculate(IAtomContainer mol) {
        if (this.checkRingSystem) {
            Cycles.markRingAtomsAndBonds((IAtomContainer)mol);
        }
        IAtomContainer aliphaticParts = mol.getBuilder().newAtomContainer();
        for (IAtom atom : mol.atoms()) {
            if (!LongestAliphaticChainDescriptor.isAcyclicCarbon(atom)) continue;
            aliphaticParts.addAtom(atom);
        }
        for (IBond bond : mol.bonds()) {
            if (!LongestAliphaticChainDescriptor.isAcyclicCarbon(bond.getBegin()) || !LongestAliphaticChainDescriptor.isAcyclicCarbon(bond.getEnd())) continue;
            aliphaticParts.addBond(bond);
        }
        int longest = 0;
        int[][] adjlist = GraphUtil.toAdjList((IAtomContainer)aliphaticParts);
        for (int i = 0; i < adjlist.length; ++i) {
            int length;
            if (adjlist[i].length != 1 || (length = LongestAliphaticChainDescriptor.getMaxDepth(adjlist, i, -1)) <= longest) continue;
            longest = length;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new IntegerResult(longest), this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{CHECK_RING_SYSTEM};
        return params;
    }

    public Object getParameterType(String name) {
        if (name.equals(CHECK_RING_SYSTEM)) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("No parameter for name: " + name);
    }
}

