/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

public class Interval<T extends Comparable<T>>
implements Comparable<Interval<T>> {
    private T low;
    private T high;
    private boolean isClosedOnLow;
    private boolean isClosedOnHigh;
    private int hashCode = 0;

    public Interval(T low, boolean isClosedOnLow, T high, boolean isClosedOnHigh) {
        if (low == null) {
            throw new NullPointerException("low endpoint is null");
        }
        if (high == null) {
            throw new NullPointerException("high endpoint is null");
        }
        this.low = low;
        this.isClosedOnLow = isClosedOnLow;
        this.high = high;
        this.isClosedOnHigh = isClosedOnHigh;
    }

    @Override
    public int compareTo(Interval<T> o) {
        int result = this.low.compareTo(o.low);
        if (result == 0) {
            if (this.isClosedOnLow != o.isClosedOnLow) {
                result = this.isClosedOnLow ? -1 : 1;
            } else {
                result = this.high.compareTo(o.high);
                if (result == 0 && this.isClosedOnHigh != o.isClosedOnHigh) {
                    result = this.isClosedOnHigh ? -1 : 1;
                }
            }
        }
        return result;
    }

    public boolean contains(Interval<T> interval) {
        boolean lowIsLowerBound = this.low.equals(interval.low) && (this.isClosedOnLow || !interval.isClosedOnLow) || this.low.compareTo(interval.low) < 0;
        boolean highIsUpperBound = this.high.equals(interval.high) && (this.isClosedOnHigh || !interval.isClosedOnHigh) || this.high.compareTo(interval.high) > 0;
        return lowIsLowerBound && highIsUpperBound;
    }

    public boolean contains(T value) {
        return value.equals(this.low) && this.isClosedOnLow || value.equals(this.high) && this.isClosedOnHigh || this.low.compareTo(value) < 0 && value.compareTo(this.high) < 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.high == null ? other.high != null : !this.high.equals(other.high)) {
            return false;
        }
        if (this.isClosedOnHigh != other.isClosedOnHigh) {
            return false;
        }
        if (this.low == null ? other.low != null : !this.low.equals(other.low)) {
            return false;
        }
        return this.isClosedOnLow == other.isClosedOnLow;
    }

    public T getHigh() {
        return this.high;
    }

    public T getLow() {
        return this.low;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.high == null ? 0 : this.high.hashCode());
            result = 31 * result + (this.isClosedOnHigh ? 1231 : 1237);
            result = 31 * result + (this.low == null ? 0 : this.low.hashCode());
            this.hashCode = result = 31 * result + (this.isClosedOnLow ? 1231 : 1237);
        }
        return this.hashCode;
    }

    public boolean isClosedOnHigh() {
        return this.isClosedOnHigh;
    }

    public boolean isClosedOnLow() {
        return this.isClosedOnLow;
    }

    public boolean overlaps(Interval<T> interval) {
        if (interval.isClosedOnLow && this.contains(interval.low) || this.isClosedOnLow && interval.contains(this.low)) {
            return true;
        }
        return !interval.isClosedOnLow && this.low.compareTo(interval.low) <= 0 && interval.low.compareTo(this.high) < 0 || !this.isClosedOnLow && interval.low.compareTo(this.low) <= 0 && this.low.compareTo(interval.high) < 0;
    }

    public String toString() {
        String format = this.isClosedOnLow ? (this.isClosedOnHigh ? "[%s, %s]" : "[%s, %s)") : (this.isClosedOnHigh ? "(%s, %s]" : "(%s, %s)");
        return String.format(format, this.low.toString(), this.high.toString());
    }
}

