% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGeneDet}
\alias{EvalGeneDet}
\title{Evaluates a gene in a deterministic problem environment.}
\usage{
EvalGeneDet(gene, lF)
}
\arguments{
\item{gene}{A gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A gene (with \code{$evaluated==TRUE}).
}
\description{
\code{EvalGeneDet()} evaluates a gene in
             a problem environment if it has not been evaluated yet.
             The repeated evaluations of a gene are omitted.
}
\details{
If the evaluation of the fitness function of the 
         problem environment fails, we catch the error and 
         return \code{NA}.
}
\examples{
Parabola2D<-Parabola2DFactory()
lF<-NewlFevalGenes(Parabola2D)
g1<-list(evaluated=FALSE, fit=0, gene1=c(1.0, -1.5))
g2<-list(evaluated=FALSE, fit=0, gene1=c(0.0, 0.0))
g1a<-EvalGeneDet(g1, lF)
EvalGeneDet(g1a, lF)
g2a<-EvalGeneDet(g2, lF)
EvalGeneDet(g2a, lF)
}
\seealso{
Other Evaluation Functions: 
\code{\link{EvalGene}()},
\code{\link{EvalGeneR}()},
\code{\link{EvalGeneStoch}()},
\code{\link{EvalGeneU}()}
}
\concept{Evaluation Functions}
