% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaUCross2Gene}
\alias{xegaGaUCross2Gene}
\title{Uniform crossover of 2 genes.}
\usage{
xegaGaUCross2Gene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{A binary gene.}

\item{gg2}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of 2 binary genes.
}
\description{
\code{xegaGaUCross2Gene()} swaps alleles of both genes
             with a probability of 0.5. It generates a random 
             mask which is used to build the new genes.
             It returns 2 genes.
}
\examples{
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene2, lFxegaGaGene)
newgenes<-xegaGaUCross2Gene(gene1, gene2, lFxegaGaGene)
xegaGaDecodeGene(newgenes[[1]], lFxegaGaGene)
xegaGaDecodeGene(newgenes[[2]], lFxegaGaGene)
}
\references{
Syswerda, Gilbert (1989):
  Uniform Crossover in Genetic Algorithms. 
  In: Schaffer, J. David (Ed.)
  Proceedings of the Third International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 2-9.
  (ISBN:1-55860-066-3)
}
\seealso{
Other Crossover (Returns 2 Kids): 
\code{\link{xegaGaCross2Gene}()},
\code{\link{xegaGaUPCross2Gene}()}
}
\concept{Crossover (Returns 2 Kids)}
