% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{restore_day_month}
\alias{restore_day_month}
\title{Revert Excel date serials to intended day.month numerics}
\usage{
restore_day_month(
  x,
  low_serial = 20000,
  high_serial = 65000,
  year_window = 1990:2035,
  origin_mode = c("auto", "1900", "1904"),
  ref_date = Sys.Date()
)
}
\arguments{
\item{x}{A vector (numeric, integer, character, or Date).}

\item{low_serial}{Lower bound for plausible serials (inclusive).}

\item{high_serial}{Upper bound for plausible serials (inclusive).}

\item{year_window}{Integer vector of years that, when resolved, will be
considered valid to revert. This guards against accidental matches.}

\item{origin_mode}{One of "auto", "1900", or "1904". In "1900" mode the
origin is "1899-12-30" (Excel’s 1900 system with the leap-year quirk
compensated). In "1904" mode the origin is "1904-01-01". In "auto" mode,
the origin yielding dates with median proximity to a reference date is
chosen; the reference can be controlled via \code{ref_date} for tests.}

\item{ref_date}{Reference date for origin selection when origin_mode="auto".
Defaults to Sys.Date(); set to a fixed Date in tests for determinism.}
}
\value{
Returns a numeric vector when restoration is unambiguous; otherwise
character vector, preserving both restored and untouched values.
}
\description{
Many spreadsheets auto-convert entries like '30.3' into dates. After import,
those values arrive as Excel date serials (integers). This function detects
such serials and reconstructs the intended 'day.month' decimals while
leaving other entries intact. Both 1900 and 1904 systems are supported.
}
\examples{
restore_day_month(c(45812, 12.5, 44730), origin_mode = "1900")
restore_day_month(c(45812, 44730), origin_mode = "auto")
}
