% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_modifiers.R
\name{add_footnote}
\alias{add_footnote}
\title{Add a footnote attribute to a table}
\usage{
add_footnote(
  data,
  footnote,
  locations = NULL,
  placement = c("auto", "right", "left")
)
}
\arguments{
\item{data}{A data frame, tibble, or \code{tsg} object to which a footnote attribute will be added.}

\item{footnote}{The footnote text to be added.}

\item{locations}{Locations where the footnote should be applied. Default is NULL (applies to entire table).}

\item{placement}{Placement of the footnote. One of "auto" (default), "right", or "left".}
}
\value{
The input data frame with an added footnote attribute.
}
\description{
Add a footnote attribute to a table
}
\examples{
add_footnote(
  dplyr::starwars,
  footnote = "This is a footnote.",
  locations = c("A1", "B2"),
  placement = "right"
)
}
