% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_color_jitter}
\alias{transform_color_jitter}
\title{Randomly change the brightness, contrast and saturation of an image}
\usage{
transform_color_jitter(
  img,
  brightness = 0,
  contrast = 0,
  saturation = 0,
  hue = 0
)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{brightness}{(float or tuple of float (min, max)): How much to jitter
brightness. \code{brightness_factor} is chosen uniformly from
\verb{[max(0, 1 - brightness), 1 + brightness]} or the given \verb{[min, max]}.
Should be non negative numbers.}

\item{contrast}{(float or tuple of float (min, max)): How much to jitter
contrast. \code{contrast_factor} is chosen uniformly from
\verb{[max(0, 1 - contrast), 1 + contrast]} or the given \verb{[min, max]}. Should
be non negative numbers.}

\item{saturation}{(float or tuple of float (min, max)): How much to jitter
saturation. \code{saturation_factor} is chosen uniformly from
\verb{[max(0, 1 - saturation), 1 + saturation]} or the given \verb{[min, max]}.
Should be non negative numbers.}

\item{hue}{(float or tuple of float (min, max)): How much to jitter hue.
\code{hue_factor} is chosen uniformly from \verb{[-hue, hue]} or the given
\verb{[min, max]}. Should have 0<= hue <= 0.5 or -0.5 <= min <= max <= 0.5.}
}
\description{
Randomly change the brightness, contrast and saturation of an image
}
\seealso{
Other random_transforms: 
\code{\link{transform_random_affine}()},
\code{\link{transform_random_crop}()},
\code{\link{transform_random_erasing}()},
\code{\link{transform_random_grayscale}()},
\code{\link{transform_random_horizontal_flip}()},
\code{\link{transform_random_perspective}()},
\code{\link{transform_random_resized_crop}()},
\code{\link{transform_random_rotation}()},
\code{\link{transform_random_vertical_flip}()}
}
\concept{random_transforms}
