% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-eurosat.R
\name{eurosat_dataset}
\alias{eurosat_dataset}
\alias{eurosat_all_bands_dataset}
\alias{eurosat100_dataset}
\title{EuroSAT datasets}
\usage{
eurosat_dataset(
  root = tempdir(),
  split = "val",
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)

eurosat_all_bands_dataset(
  root = tempdir(),
  split = "val",
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)

eurosat100_dataset(
  root = tempdir(),
  split = "val",
  download = FALSE,
  transform = NULL,
  target_transform = NULL
)
}
\arguments{
\item{root}{(Optional) Character. The root directory where the dataset will be stored.
if empty, will use the default \code{rappdirs::user_cache_dir("torch")}.}

\item{split}{One of \code{"train"}, \code{"val"}, or \code{"test"}. Default is \code{"val"}.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}
}
\value{
A \code{torch::dataset} object. Each item is a list with:
\itemize{
\item \code{x}: a 64x64 image tensor with 3 (RGB) or 13 (all bands) channels
\item \code{y}: the class label
}
}
\description{
A collection of Sentinel-2 satellite images for land-use \strong{classification}.
The standard version contains 27,000 RGB thumbnails (64x64) across 10
classes. Variants include the full 13 spectral bands and a small 100-image
subset useful for demos.

Downloads and prepares the EuroSAT dataset with 13 spectral bands.

A subset of 100 images with 13 spectral bands useful for workshops and demos.
}
\details{
\code{eurosat_dataset()} provides a total of 27,000 RGB labeled images.

\code{eurosat_all_bands_dataset()} provides a total of 27,000 labeled images with 13 spectral channel bands.

\code{eurosat100_dataset()} provides a subset of 100 labeled images with 13 spectral channel bands.
}
\examples{
\dontrun{
# Initialize the dataset
ds <- eurosat100_dataset(split = "train", download = TRUE)

# Access the first item
head <- ds[1]
print(head$x) # Image
print(head$y) # Label
}
}
\seealso{
Other classification_dataset: 
\code{\link{caltech_dataset}},
\code{\link{cifar10_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{image_folder_dataset}()},
\code{\link{lfw_dataset}},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{places365_dataset}()},
\code{\link{tiny_imagenet_dataset}()},
\code{\link{whoi_plankton_dataset}()},
\code{\link{whoi_small_coralnet_dataset}()}
}
\concept{classification_dataset}
