% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{effect}
\alias{effect}
\alias{print.effect}
\title{Effects Estimate in Linear, Logistic and Poisson Regression Models
with Transformed Variables}
\usage{
effect(
  object,
  x1 = NULL,
  x2 = NULL,
  c = NULL,
  q = NULL,
  r = NULL,
  npoints = NULL,
  level = 0.95,
  nboot = 999,
  seed = 4321,
  verbose = TRUE
)

\method{print}{effect}(x, ...)
}
\arguments{
\item{object}{object of class "\code{tlm}", a result of a call to \code{\link{tlm}}.}

\item{x1}{numeric. The values of the explanatory variable where the effect
should be computed. See Details below.}

\item{x2}{numeric. The alternative values of the explanatory variable
(changing from \code{x1}) for which the effect should be computed. See
Details below.}

\item{c}{numeric. The additive change in the explanatory variable. See Details
below.}

\item{q}{numeric. The multiplicative change in the explanatory variable. See
Details below.}

\item{r}{numeric. The percent change in the explanatory variable. See Details
below.}

\item{npoints}{numeric. The number of points where the effect should be
computed. See Details below.}

\item{level}{numeric. Confidence level for the effect estimate. Default is 0.95.}

\item{nboot}{numeric. The number of non parametric bootstrap samples to compute
confidence intervals. Default is 999. See Details below.}

\item{seed}{numeric. A single value, the seed for bootstrapping. Default is
4321.}

\item{verbose}{logical. Whether to print detailed progress on R prompt.
Default is \code{TRUE}.}

\item{x}{for \code{print.effect}, an object of class "\code{effect}" (an output
of the \code{effect} function).}

\item{\dots}{additional arguments for \code{print.effect}.}
}
\value{
A list with class "\code{effect}" including the following items:
\describe{
\item{effect}{point estimate and confidence interval for the effect size.}
\item{info}{information on how to interpret the effect. Used by the function
\code{\link{effectInfo}}.}
}
}
\description{
Estimates the effect of a explanatory variable of interest on a
response variable, under a fitted linear, logistic or Poisson regression model
with transformed variables. The effect is reported in the original scale of the
variables.
}
\details{
In order to compute the effect, both the initial and the final values
of the explanatory should be provided. It can be done in several ways. For
instance, providing, \code{x1} and \code{x2}; \code{x1} and one of \code{c},
\code{q} or \code{r}; \code{x1}, \code{npoints} and one of \code{c},
\code{q} or \code{r}. Only one of the arguments \code{c}, \code{q} or
\code{r} is used, prevailing \code{c} and then \code{q}. If no enough
arguments are passed, the interquartile range will be considered and a
summary effect is computed, if it exists.

Confidence intervals are computed by transforming the endpoints of the
intervals in the transformed scale when it is possible, while non-parametric
bootstrap is used otherwise.
}
\examples{
### Linear model with log transformation in the response variable:
data(imt)
head(imt)

# model fitting:
modimt <- tlm(logimt ~ age, data = imt, ypow = 0)
modimt

# information on interpreting the effect:
effectInfo(modimt)

# the function effect provides as default the expected change in IMT
# for an additive change in age equal to the interquartile range:
effect(modimt)

# other effects:
(minage <- min(imt$age))
(maxage <- max(imt$age))
effect(modimt, c = maxage - minage)

\dontrun{
 effect(modimt, x1 = minage, r = 50, npoints = 3)}
}
\references{
Barrera-Gomez J, Basagana X. Models with transformed variables:
interpretation and software. \emph{Epidemiology}. 2015;26(2):e16-17.
}
\seealso{
\code{\link{tlm}}, \code{\link{effectInfo}}, \code{\link{MY}}.
}
