% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{increase_numeric_resolution}
\alias{increase_numeric_resolution}
\title{Increase numeric vector resolution}
\usage{
increase_numeric_resolution(
  y,
  n,
  method = c("interpolate", "repeat", "divide")
)
}
\arguments{
\item{y}{original numeric vector}

\item{n}{integer, number of intra-values (counting the original value as the first one)}

\item{method}{character, being \code{interpolate}, \code{repeat} or \code{divide} as valid options}
}
\value{
numeric vector
}
\description{
Increase numeric vector resolution
}
\details{
if we have a vector v = c(1, 2), and we choose the \code{interpolate} method,
then:

\code{increase_numeric_resolution(v, 4, 'interpolate')}

returns \code{c(1, 1.25, 1.5, 1.75, 2)}

if we choose the \code{repeat} method, then:

\code{increase_numeric_resolution(v, 4, 'repeat')}

returns c(1, 1, 1, 1, 2)
}
\keyword{internal}
