% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-stats.R
\name{fit_arima}
\alias{fit_arima}
\title{Fit an ARIMA model}
\usage{
fit_arima(x, tau, ...)
}
\arguments{
\item{x}{A time series}

\item{tau}{a set of indices representing a changepoint set}

\item{...}{currently ignored}
}
\value{
A \link{mod_cpt} object.
}
\description{
Fit an ARIMA model
}
\details{
Fits an ARIMA model using \code{\link[stats:arima]{stats::arima()}}.
}
\examples{
# Fit a mean-variance model
fit_arima(CET, tau = c(42, 330))

}
\seealso{
\code{\link[changepointGA:ARIMA.BIC]{changepointGA::ARIMA.BIC()}}

Other model-fitting: 
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()},
\code{\link{whomademe}()}
}
\concept{model-fitting}
