% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/pkg-stats.R
\name{MDL}
\alias{MDL}
\alias{MDL.default}
\alias{MDL.logLik}
\title{Maximum Descriptive Length}
\usage{
MDL(object, ...)

\method{MDL}{default}(object, ...)

\method{MDL}{logLik}(object, ...)
}
\arguments{
\item{object}{any object from which a log-likelihood value, or a
   contribution to a log-likelihood value, can be extracted.}

\item{...}{some methods for this generic function require additional
   arguments.}
}
\value{
A \code{double} vector of length 1
}
\description{
Generic function to compute the Maximum Descriptive Length for a
changepoint detection model.
}
\details{
\deqn{
   P_{MDL}(\tau) = \frac{a(\theta_\tau)}{2} \cdot 
     \sum_{j=0}^m \log{\left(\tau_j - \tau_{j-1} \right)} + 2 \ln{m} + \sum_{j=2}^m \ln{\tau_j} + 
     \left( 2 + b(\theta_\tau) \right) \ln{n} 
 }
where \eqn{a(\theta)} is the number of parameters in \eqn{\theta} that are
fit in each region, and \eqn{b(\theta)} is the number of parameters
fit to the model as a whole.

These quantities should be \code{\link[base:attributes]{base::attributes()}} of the object returned by
\code{\link[=logLik]{logLik()}}.
}
\examples{
MDL(fit_meanshift_norm_ar1(CET, tau = c(42, 330)))
MDL(fit_trendshift(CET, tau = c(42, 81, 330)))
}
\seealso{
Other penalty-functions: 
\code{\link{BMDL}()},
\code{\link{HQC}()},
\code{\link{MBIC}()},
\code{\link{SIC}()}
}
\concept{penalty-functions}
