% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_insights.R
\name{display_val_frmts}
\alias{display_val_frmts}
\title{Display formatted values}
\usage{
display_val_frmts(tfrmt, .data, mock = FALSE, col = NULL)
}
\arguments{
\item{tfrmt}{tfrmt object to apply to the data}

\item{.data}{Data to apply the tfrmt to}

\item{mock}{Mock table? TRUE or FALSE (default)}

\item{col}{Column value to align on from \code{column} variable. May be a quoted
or unquoted column name, a tidyselect semantic, or a span_structure.}
}
\value{
text representing character vector of formatted values to be copied and modified in the col_style_plan
}
\description{
A helper for creating positional-alignment specifications for the col_style_plan.
Returns all unique formatted values to appear in the column(s) specified. Numeric values are represented by x's.
}
\examples{
 tf_spec <- tfrmt(
 group = c(rowlbl1,grp),
 label = rowlbl2,
 column = column,
 param = param,
 value = value,
 sorting_cols = c(ord1, ord2),
 body_plan = body_plan(
 frmt_structure(group_val = ".default", label_val = ".default", frmt_combine("{n} ({pct} \%)",
                                                                             n = frmt("xxx"),
                                                                             pct = frmt("xx.x"))),
 frmt_structure(group_val = ".default", label_val = "n", frmt("xxx")),
 frmt_structure(group_val = ".default", label_val = c("Mean", "Median", "Min","Max"),
                             frmt("xxx.x")),
 frmt_structure(group_val = ".default", label_val = "SD", frmt("xxx.xx")),
 frmt_structure(group_val = ".default", label_val = ".default",
                            p = frmt_when(">0.99" ~ ">0.99",
                                          "<0.15" ~ "<0.15",
                                          TRUE ~ frmt("x.xxx", missing = "")))
))

 display_val_frmts(tf_spec, data_demog, col = vars(everything()))
 display_val_frmts(tf_spec, data_demog, col = "p-value")
}
