% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucarima.R
\name{ucarima}
\alias{ucarima}
\title{Unobserved components ARIMA models}
\usage{
ucarima(
  z = NULL,
  bc = FALSE,
  ucm = NULL,
  ar = NULL,
  xreg = NULL,
  fit = TRUE,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{z}{an object of class \code{ts} or NULL to specify theoretical models.}

\item{bc}{logical. If TRUE logs are taken.}

\item{ucm}{a list of \code{um} objects specifying the ARIMA models for
components such as trend, seasonality, and irregular terms. Alternatively,
can be a character string: \code{"ht"} for Harvey-Todd seasonal
decomposition, or \code{NULL}/missing for Harvey-Durbin seasonal
decomposition (default when only time series \code{z} is provided).}

\item{ar}{list of stationary AR lag polynomials (\code{lagpol} objects).}

\item{xreg}{matrix of explanatory variables.}

\item{fit}{logical. If TRUE, model is fitted.}

\item{envir}{environment.}

\item{...}{additional arguments.}
}
\value{
An object of class \code{ucarima}.
}
\description{
\code{ucarima} creates an S3 object that combines two or more ARIMA models
(objects of class \code{\link{um}}).
}
\examples{
trend <- um(i = "(1 - B)", sig2 = c(s2t = 1))
seas <- um(i = "(1+B)", sig2 = c(s2s = 0.05))
irreg <- um(sig2 = c(s2i = 0.75))
uca1 <- ucarima(ucm = list(trend = trend, seas = seas, irreg = irreg))
uca1

# Trigonometric seasonality
uca2 <- ucarima(AirPassengers, bc = TRUE)
uca2

# Dummy seasonality
uca3 <- ucarima(AirPassengers, bc = TRUE, ucm = "ht")
uca3

}
\references{
Harvey, A.C. (1989) Forecasting, Structural Time Series Models
and the Kalman Filter. Cambridge University Press, Cambridge.
}
