% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ucarima.R, R/um.R
\name{as.ssm.ucarima}
\alias{as.ssm.ucarima}
\alias{as.ssm}
\alias{as.ssm.um}
\title{Structural form for an ARIMA model}
\usage{
\method{as.ssm}{ucarima}(object, ...)

as.ssm(object, ...)

\method{as.ssm}{um}(
  object,
  z = NULL,
  msoe = TRUE,
  H = NULL,
  cform = TRUE,
  tol = 1.490116e-08,
  nonadm = c("quadprog", "nnls", "none"),
  envir = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{um}.}

\item{...}{other arguments.}

\item{z}{an optional time series.}

\item{msoe}{logical, TRUE for multiple source of errors and FALSE for single
source of error.}

\item{H}{an optional matrix to reduce the number of variances.}

\item{cform}{logical. TRUE for contemporaneous form and FALSE for future
form.}

\item{tol}{tolerance to check if the elements of b and C are zero.}

\item{nonadm}{character, the method to overcome nonadmissibility: non-linear 
least squares, quadratic programming or none.}

\item{envir}{environment, see "\code{\link{um}}".}
}
\value{
An object of class \code{ssm}
}
\description{
\code{as.ssm} finds the structural form for an ARIMA model from its the
eventual forecast function.
}
\examples{

airl <- um(i = list(1, c(1, 12)), ma = "(1 - 0.8B)(1 - 0.8B12)")
ssm1 <- as.ssm(airl, index = c(1, 0, rep(2, 11)))
ssm1

}
