% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing-createtablescores.R
\name{createtablescores}
\alias{createtablescores}
\title{Create a Unified Table of Scores}
\usage{
createtablescores(tmpfold, exptabpath, showmemory = FALSE, showtime = FALSE,
  savefinaltable = TRUE, finaltabpath = tempdir(), finaltabname = "anno.tsv",
 verbose)
}
\arguments{
\item{tmpfold}{A string specifying the temporary folder containing the
score files created with the function 'blacklisthighmap'.}

\item{exptabpath}{Path to the experiment table file containing a table with
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{showmemory}{Logical; if `TRUE`, memory usage is printed during
processing. Default is `FALSE`.}

\item{showtime}{Logical; if `TRUE`, the execution time of the function is
printed. Default is `FALSE`.}

\item{savefinaltable}{Logical; if `TRUE`, the resulting table is saved to
disk. Default is `TRUE`.}

\item{finaltabpath}{A string specifying the directory where the final table
should be saved. Default is \code{tempdir()}.}

\item{finaltabname}{A string specifying the name of the final table file.
Default is `"anno.tsv"`.}

\item{verbose}{Logical; if `TRUE`, detailed messages are printed during
execution.}
}
\value{
A data frame containing the unified table of scores.
}
\description{
This function processes and combines table scores of each bedgraph and each
chromosome stored in the temporary folder into a unified table.
}
\details{
This function first merges files belonging to the same experiment and
direction. These files are combined into a single table providing two columns
per experiment. The first gives the name of the experiment and the second the
scores. The resulting table also includes annotations for each transcript.
}
\examples{
\donttest{
exptabpath <- system.file("extdata", "exptab-preprocessing.csv", package="tepr")
gencodepath <- system.file("extdata", "gencode-chr13.gtf", package = "tepr")
maptrackpath <- system.file("extdata", "k50.umap.chr13.hg38.0.8.bed",
package = "tepr")
blacklistpath <- system.file("extdata", "hg38-blacklist-chr13.v2.bed",
    package = "tepr")
tmpfoldpath <- file.path(tempdir(), "tmptepr")
windsize <- 200
genomename <- "hg38"
chromtabtest <- rtracklayer::SeqinfoForUCSCGenome(genomename)
allchromvec <- GenomeInfoDb::seqnames(chromtabtest)
chromtabtest <- chromtabtest[allchromvec[which(allchromvec == "chr13")], ]

## Copying bedgraphs to the current directory
expdfpre <- read.csv(exptabpath)
bgpathvec <- sapply(expdfpre$path, function(x) system.file("extdata", x,
    package = "tepr"))
expdfpre$path <- bgpathvec
write.csv(expdfpre, file = "exptab-preprocessing.csv", row.names = FALSE,
    quote = FALSE)
exptabpath <- "exptab-preprocessing.csv"

## Necessary result to call createtablescores
allannobed <- retrieveanno(exptabpath, gencodepath, verbose = FALSE)
allwindowsbed <- makewindows(allannobed, windsize, verbose = FALSE)
blacklisthighmap(maptrackpath, blacklistpath, exptabpath, nbcputrans = 1,
    allwindowsbed, windsize, genomename = genomename, chromtab = chromtabtest,
    verbose = FALSE)

## Calling the function to test
finaltabtest <- createtablescores(tmpfold = tmpfoldpath, exptabpath,
    savefinaltable = FALSE, verbose = FALSE)}

}
\seealso{
[blacklisthighmap]
}
