% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aipw.R
\name{aipw}
\alias{aipw}
\title{AIPW estimator}
\usage{
aipw(response_model, propensity_model, formula = ~1, data, ...)
}
\arguments{
\item{response_model}{Model for the response given covariates (learner or
formula)}

\item{propensity_model}{Optional missing data mechanism model (propensity
model) (learner or formula)}

\item{formula}{design specifying the OLS estimator with outcome given by the
EIF}

\item{data}{data.frame}

\item{...}{additional arguments (see \code{\link[=cate]{cate()}})}
}
\description{
AIPW for the mean (and linear projections of the EIF) with missing
observations
}
\examples{
m <- lava::lvm(y ~ x+z, r ~ x) |>
     lava::distribution(~ r, value = lava::binomial.lvm()) |>
     transform(y0~r+y, value = \(x) { x[x[,1]==0,2] <- NA; x[,2] })
d <- lava::sim(m,1e3,seed=1)

aipw(y0 ~ x, data=d)
}
