% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{sd_db_config}
\alias{sd_db_config}
\title{Configure database settings}
\usage{
sd_db_config(
  host = NULL,
  dbname = NULL,
  port = NULL,
  user = NULL,
  table = NULL,
  password = NULL,
  interactive = NULL
)
}
\arguments{
\item{host}{Character string. Database host}

\item{dbname}{Character string. Database name}

\item{port}{Character string. Database port}

\item{user}{Character string. Database user}

\item{table}{Character string. Table name}

\item{password}{Character string. Database password}

\item{interactive}{Logical. Whether to use interactive setup. Defaults to TRUE if no parameters provided}
}
\value{
Invisibly returns a list of the current configuration settings
}
\description{
Set up or modify database configuration settings in a .env file. These settings
are used to establish database connections for storing survey responses.
}
\examples{
if (interactive()) {
  # Interactive setup
  sd_db_config()

  # Update specific settings
  sd_db_config(table = "new_table")

  # Update multiple settings
  sd_db_config(
    host = "new_host",
    port = "5433",
    table = "new_table"
  )
}


}
\seealso{
\itemize{
\item \code{\link[=sd_db_connect]{sd_db_connect()}} to connect to the database
}
}
\concept{database functions}
