% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allgenerics.R
\name{meanRecurrenceTimes}
\alias{meanRecurrenceTimes}
\title{Method to get the mean recurrence times \eqn{\mu}}
\usage{
meanRecurrenceTimes(x, klim = 10000)
}
\arguments{
\item{x}{An object of S3 class \code{smmfit} or \code{smm}.}

\item{klim}{Optional. The time horizon used to approximate the series in the
computation of the mean sojourn times vector \eqn{m} (cf.
\link{meanSojournTimes} function).}
}
\value{
A vector giving the mean recurrence time
\eqn{(\mu_{i})_{i \in [1,\dots,s]}}.
}
\description{
Method to get the mean recurrence times \eqn{\mu}.
}
\details{
Consider a system (or a component) \eqn{S_{ystem}} whose possible
states during its evolution in time are \eqn{E = \{1,\dots,s\}}.

We are interested in investigating the mean recurrence times of a
discrete-time semi-Markov system \eqn{S_{ystem}}. Consequently, we suppose
that the evolution in time of the system is governed by an E-state space
semi-Markov chain \eqn{(Z_k)_{k \in N}}. The state of the system is given
at each instant \eqn{k \in N} by \eqn{Z_k}: the event \eqn{\{Z_k = i\}}.

Let \eqn{T = (T_{n})_{n \in N}} denote the successive time points when
state changes in \eqn{(Z_{n})_{n \in N}} occur and let also
\eqn{J = (J_{n})_{n \in N}} denote the successively visited states at
these time points.

The mean recurrence of an arbitrary state \eqn{j \in E} is given by:

\deqn{\mu_{jj} = \frac{\sum_{i \in E} \nu(i) m_{i}}{\nu(j)}}

where \eqn{(\nu(1),\dots,\nu(s))} is the stationary distribution of the
embedded Markov chain \eqn{(J_{n})_{n \in N}} and \eqn{m_{i}} is the mean
sojourn time in state \eqn{i \in E} (see \link{meanSojournTimes} function for
the computation).
}
