% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_simplify}
\alias{ts_simplify}
\title{Simplify the tree sequence down to a given set of individuals}
\usage{
ts_simplify(
  ts,
  simplify_to = NULL,
  keep_input_roots = FALSE,
  keep_unary = FALSE,
  keep_unary_in_individuals = FALSE,
  filter_nodes = TRUE
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{simplify_to}{A character vector of individual names. If NULL, all
explicitly remembered individuals (i.e. those specified via the
\code{\link{schedule_sampling}} function will be left in the tree sequence
after the simplification.}

\item{keep_input_roots}{Should the history ancestral to the MRCA of all
samples be retained in the tree sequence? Default is \code{FALSE}.}

\item{keep_unary}{Should unary nodes be preserved through simplification?
Default is \code{FALSE}.}

\item{keep_unary_in_individuals}{Should unary nodes be preserved through
simplification if they are associated with an individual recorded in
the table of individuals? Default is \code{FALSE}. Cannot be set to
\code{TRUE} if \code{keep_unary} is also TRUE}

\item{filter_nodes}{Should nodes be reindexed after simplification? Default is
\code{TRUE}. See tskit's documentation for the Python method \code{simplify()}}
}
\value{
Tree-sequence object of the class \code{slendr_ts}, which serves as
an interface point for the Python module tskit using slendr functions with
the \code{ts_} prefix.
}
\description{
This function is a convenience wrapper around the \code{simplify} method
implemented in tskit, designed to work on tree sequence data simulated by
SLiM using the \pkg{slendr} R package.
}
\details{
The simplification process is used to remove redundant information from the
tree sequence and retains only information necessary to describe the
genealogical history of a set of samples.

For more information on how simplification works in pyslim and tskit, see the
official documentation at
\url{https://tskit.dev/tskit/docs/stable/python-api.html#tskit.TreeSequence.simplify}
and \url{https://tskit.dev/pyslim/docs/latest/tutorial.html#simplification}.

A very clear description of the difference between remembering and retaining
and how to use these techniques to implement historical individuals (i.e.
ancient DNA samples) is in the pyslim documentation at
\url{https://tskit.dev/pyslim/docs/latest/tutorial.html#historical-individuals}.
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression_slim.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

ts <- ts_read(slendr_ts, model)
ts

# simplify tree sequence to sampled individuals
ts_simplified <- ts_simplify(ts)

# simplify to a subset of sampled individuals
ts_small <- ts_simplify(ts, simplify_to = c("CH_1", "NEA_1", "NEA_2", "AFR_1",
                                            "AFR_2", "EUR_1", "EUR_2"))

ts_small
}
\seealso{
\code{\link{ts_nodes}} for extracting useful information about
individuals, nodes, coalescent times and geospatial locations of nodes on a
map
}
