% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize_explanation.R
\name{compute_MSEv_eval_crit}
\alias{compute_MSEv_eval_crit}
\title{Mean squared error of the contribution function \code{v(S)}}
\usage{
compute_MSEv_eval_crit(
  internal,
  dt_vS,
  MSEv_uniform_comb_weights,
  MSEv_skip_empty_full_comb = TRUE
)
}
\arguments{
\item{internal}{List.
Holds all parameters, data, functions and computed objects used within \code{\link[=explain]{explain()}}
The list contains one or more of the elements \code{parameters}, \code{data}, \code{objects}, \code{iter_list}, \code{timing_list},
\code{main_timing_list}, \code{output}, and \code{iter_timing_list}.}

\item{dt_vS}{Data.table of dimension \code{n_coalitions} times \code{n_explain + 1} containing the contribution function
estimates. The first column is assumed to be named \code{id_coalition} and containing the ids of the coalitions.
The last row is assumed to be the full coalition, i.e., it contains the predicted responses for the observations
which are to be explained.}

\item{MSEv_uniform_comb_weights}{Logical.
If \code{TRUE} (default), then the function weights the coalitions uniformly when computing the MSEv criterion.
If \code{FALSE}, then the function use the Shapley kernel weights to weight the coalitions when computing the MSEv
criterion.
Note that the Shapley kernel weights are replaced by the sampling frequency when not all coalitions are considered.}

\item{MSEv_skip_empty_full_comb}{Logical. If \code{TRUE} (default), exclude the empty and grand
coalitions when computing the MSEv evaluation criterion. This is reasonable as they are identical
for all methods, i.e., their contribution function is independent of the method used (special cases not
affected by the approach). If \code{FALSE}, include the empty and grand coalitions. In that case,
we recommend setting \code{MSEv_uniform_comb_weights = TRUE}; otherwise the large weights for the empty and
grand coalitions will outweigh all others and make the MSEv criterion uninformative.}
}
\value{
List containing:
\describe{
\item{\code{MSEv}}{A \code{\link[data.table]{data.table}} with the overall MSEv evaluation criterion averaged
over both the coalitions and observations/explicands. The \code{\link[data.table]{data.table}}
also contains the standard deviation of the MSEv values for each explicand (only averaged over the coalitions)
divided by the square root of the number of explicands.}
\item{\code{MSEv_explicand}}{A \code{\link[data.table]{data.table}} with the mean squared error for each
explicand, i.e., only averaged over the coalitions.}
\item{\code{MSEv_coalition}}{A \code{\link[data.table]{data.table}} with the mean squared error for each
coalition, i.e., only averaged over the explicands/observations.
The \code{\link[data.table]{data.table}} also contains the standard deviation of the MSEv values for
each coalition divided by the square root of the number of explicands.}
}
}
\description{
Compute the mean squared error (MSEv) of the contribution function
v(S) as proposed by \href{https://arxiv.org/pdf/2006.01272}{Frye et al. (2019)} and used by
\href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{Olsen et al. (2022)}.
}
\details{
The MSEv evaluation criterion does not rely on access to the true contribution functions or the
true Shapley values. A lower value indicates better approximations; however, the
scale and magnitude of MSEv are not directly interpretable regarding the precision
of the final estimated Shapley values.
\href{https://link.springer.com/content/pdf/10.1007/s10618-024-01016-z.pdf}{Olsen et al. (2024)}
illustrates (Figure 11) a fairly strong linear relationship between MSEv and the
MAE between the estimated and true Shapley values in a simulation study. Note: explicands
are the observations whose predictions we explain.
}
\references{
\itemize{
\item \href{https://arxiv.org/pdf/2006.01272}{
Frye, C., de Mijolla, D., Begley, T., Cowton, L., Stanley, M., & Feige, I. (2021).
Shapley explainability on the data manifold. In International Conference on Learning Representations.}
\item \href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{
Olsen, L. H., Glad, I. K., Jullum, M., & Aas, K. (2022). Using Shapley values and variational autoencoders to
explain predictive models with dependent mixed features. Journal of machine learning research, 23(213), 1-51}
\item \href{https://link.springer.com/content/pdf/10.1007/s10618-024-01016-z.pdf}{
Olsen, L. H. B., Glad, I. K., Jullum, M., & Aas, K. (2024). A comparative study of methods for estimating
model-agnostic Shapley value explanations. Data Mining and Knowledge Discovery, 1-48}
}
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
