% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities_Objects.R
\name{ReFilter_SeuratObject}
\alias{ReFilter_SeuratObject}
\title{Re-filter Seurat object}
\usage{
ReFilter_SeuratObject(
  seurat_object,
  min.cells = NULL,
  min.features = NULL,
  override = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_object}{Seurat object to filter}

\item{min.cells}{Include features detected in at least this many cells. Will recalculate nCount and nFeature
meta.data values as well.}

\item{min.features}{Include cells where at least this many features are detected.}

\item{override}{logical, override the Yes/No interactive check (see details).  Default is FALSE; don't override.}

\item{verbose}{logical, whether to print information on filtering parameters and number of cells/features
removed, Default is TRUE.}
}
\value{
Seurat object
}
\description{
Allows for re-filtering of Seurat object based on new parameters for \code{min.cells} and
\code{min.features} (see \code{\link[SeuratObject]{CreateSeuratObject}} for more details)
}
\details{
When running this function any existing reductions, graphs, and all layers except "counts" in the
RNA assay.  None of these aspects will be valid once cells/features are removed.
To ensure users understand this default behavior of function will provide interactive prompt that
users must select "Yes" in order to continue. To avoid this behavior users can set \code{override = TRUE} and
function will skip the interactive prompt.
}
\examples{
\dontrun{
# Remove features expressed in fewer than 10 cells
obj_fil <- ReFilter_SeuratObject(seurat_object = obj, min.cells = 10)

# Remove cells with fewer than 1000 features
obj_fil <- ReFilter_SeuratObject(seurat_object = obj, min.features = 1000)

# Filter on both parameters
obj_fil <- ReFilter_SeuratObject(seurat_object = obj, min.features = 1000, min.cells = 10)
}
}
\concept{misc_util}
