% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Get_Reference_LIGER}
\alias{Get_Reference_LIGER}
\title{Get Reference Dataset}
\usage{
Get_Reference_LIGER(liger_object, meta_data_column, value)
}
\arguments{
\item{liger_object}{LIGER object name.}

\item{meta_data_column}{meta data column to use for selecting largest dataset.}

\item{value}{value from column \code{meta_data_column} to use for selecting largest dataset.}
}
\value{
dataset name as character
}
\description{
Function to select reference dataset to use in liger based on meta data information
}
\examples{
\dontrun{
# standalone use
ref_dataset <- Get_Reference_LIGER(liger_object = object, meta_data_column = "Treatment",
value = "Ctrl")

# use within `quantileNorm`
object <- quantileNorm(object = object, reference = Get_Reference_LIGER(liger_object = object,
meta_data_column = "Treatment", value = "Ctrl"))
}

}
\concept{liger_object_util}
