% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Color_Palettes.R
\name{DiscretePalette_scCustomize}
\alias{DiscretePalette_scCustomize}
\title{Discrete color palettes}
\usage{
DiscretePalette_scCustomize(
  num_colors,
  palette = NULL,
  shuffle_pal = FALSE,
  seed = 123
)
}
\arguments{
\item{num_colors}{Number of colors to be generated.}

\item{palette}{Options are
"alphabet", "alphabet2", "glasbey", "polychrome", "stepped", "ditto_seq", "varibow".}

\item{shuffle_pal}{randomly shuffle the outputted palette.  Most useful for \code{varibow} palette as
that is normally an ordered palette.}

\item{seed}{random seed for the palette shuffle.  Default = 123.}
}
\value{
A vector of colors
}
\description{
Helper function to return a number of discrete color palettes.
}
\examples{
pal <- DiscretePalette_scCustomize(num_colors = 36, palette = "varibow")
PalettePlot(pal= pal)

}
\references{
This function uses the paletteer package \url{https://github.com/EmilHvitfeldt/paletteer} to
provide simplified access to color palettes from many different R package sources while
minimizing scCustomize current and future dependencies.

The following packages & palettes are called by this function (see individual packages for
palette references/citations):
\enumerate{
\item pals (via paletteer) \url{https://CRAN.R-project.org/package=pals}
\itemize{
\item alphabet, alphabet2, glasbey, polychrome, and stepped.
}
\item dittoSeq \url{https://bioconductor.org/packages/release/bioc/html/dittoSeq.html}
\itemize{
\item dittoColors.
}
\item colorway \url{https://github.com/hypercompetent/colorway}
\itemize{
\item varibow
}
}

Function name and implementation modified from Seurat (License: GPL-3).
\url{https://github.com/satijalab/seurat}
}
\concept{palettes}
