% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeme_helpers.R
\name{resolve_variable_overlaps}
\alias{resolve_variable_overlaps}
\title{Resolve Variable Overlaps Between Dependent and Independent Variables}
\usage{
resolve_variable_overlaps(dep, indep)
}
\arguments{
\item{dep}{Character vector of dependent variable names}

\item{indep}{Character vector of independent variable names}
}
\value{
Character vector of dependent variable names with overlaps removed
}
\description{
Internal helper function that handles cases where variables are selected for
both dependent and independent roles. Automatically removes overlapping variables
from the dependent list and provides user feedback.
}
\details{
If overlapping variables are found:
\itemize{
\item Informs user about the overlap via cli::cli_inform()
\item Removes overlapping variables from dep vector
\item Throws error if no dependent variables remain after removal
}
}
\keyword{internal}
