% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{testRxLinCmt}
\alias{testRxLinCmt}
\alias{assertRxLinCmt}
\title{Test if rxode2 uses linear solved systems}
\usage{
testRxLinCmt(ui, extra = "", .var.name = .vname(ui))

assertRxLinCmt(ui, extra = "", .var.name = .vname(ui))
}
\arguments{
\item{ui}{rxode2 model}

\item{extra}{Extra text to append to the error message (like
"for focei")}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
TRUE if the model uses linear solved systems, FALSE otherwise
}
\description{
Test if rxode2 uses linear solved systems
}
\section{Functions}{
\itemize{
\item \code{assertRxLinCmt()}: Assert that the rxode2 uses linear solved systems

}}
\examples{

one.cmt <- function() {
  ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Log Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

testRxLinCmt(one.cmt)

}
\author{
Matthew L. Fidler
}
