% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode2.R
\name{rxMd5}
\alias{rxMd5}
\title{Return the md5 of an rxode2 object or file}
\usage{
rxMd5(model, ...)
}
\arguments{
\item{model}{This is the ODE model specification.  It can be:
\itemize{
\item a string containing the set of ordinary differential
equations (ODE) and other expressions defining the changes in
the dynamic system.
\item a file name where the ODE system equation is contained
}

An ODE expression enclosed in \verb{\\\{\\\}}

(see also the \code{filename} argument). For
details, see the sections \dQuote{Details} and
\verb{rxode2 Syntax} below.}

\item{...}{ignored arguments}
}
\value{
If this is a rxode2 object, return a named list:
\itemize{
\item \code{file_md5} is the model's file's md5
\item \code{parsed_md5}  is the parsed model's file's md5.
}

Otherwise return the md5 based on the arguments provided
}
\description{
This md5 is based on the model and possibly the extra c code
supplied for the model.  In addition the md5 is based on syntax
options, compiled rxode2 library md5, and the rxode2
version/repository.
}
\author{
Matthew L.Fidler
}
\keyword{internal}
